package org.infinispan.extendedstats.wrappers;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ModuleLifecycle;

/**
 * @api.private 
 */
@Generated(value = "org.infinispan.component.processor.Generator", date = "2023-09-08T10:51:17.107601133Z")
public final class ExtendedStatisticsPackageImpl {
   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {
//start org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor
      builder.registerComponentAccessor("org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor",
         Collections.emptyList(),
         new ComponentAccessor<ExtendedStatisticInterceptor>("org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor",
            1, false, "org.infinispan.interceptors.BaseCustomAsyncInterceptor",
            Arrays.asList("org.infinispan.factories.impl.BasicComponentRegistry", "org.infinispan.commons.time.TimeService", "org.infinispan.transaction.impl.TransactionTable", "org.infinispan.distribution.DistributionManager")) {
         protected void wire(ExtendedStatisticInterceptor instance, WireContext context, boolean start) {
            instance.componentRegistry = context.get("org.infinispan.factories.impl.BasicComponentRegistry", org.infinispan.factories.impl.BasicComponentRegistry.class, start);
            instance.timeService = context.get("org.infinispan.commons.time.TimeService", org.infinispan.commons.time.TimeService.class, start);
            instance.transactionTable = context.get("org.infinispan.transaction.impl.TransactionTable", org.infinispan.transaction.impl.TransactionTable.class, start);
            instance.distributionManager = context.get("org.infinispan.distribution.DistributionManager", org.infinispan.distribution.DistributionManager.class, start);
         }

      });

      builder.registerMBeanMetadata("org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor",
         MBeanMetadata.of("ExtendedStatistics", "Component that manages and exposes extended statistics relevant to transactions.", null,
            new AttributeMetadata("avgPrepareRtt", "Average Prepare Round-Trip Time duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgPrepareRtt, null, false),
            new AttributeMetadata("avgCommitRtt", "Average Commit Round-Trip Time duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgCommitRtt, null, false),
            new AttributeMetadata("avgRemoteGetRtt", "Average Remote Get Round-Trip Time duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteGetRtt, null, false),
            new AttributeMetadata("avgRollbackRtt", "Average Rollback Round-Trip Time duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRollbackRtt, null, false),
            new AttributeMetadata("avgCompleteNotificationAsync", "Average asynchronous Complete Notification duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgCompleteNotificationAsync, null, false),
            new AttributeMetadata("avgNumNodesCommit", "Average number of nodes in Commit destination set", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumNodesCommit, null, false),
            new AttributeMetadata("avgNumNodesCompleteNotification", "Average number of nodes in Complete Notification destination set", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumNodesCompleteNotification, null, false),
            new AttributeMetadata("avgNumNodesRemoteGet", "Average number of nodes in Remote Get destination set", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumNodesRemoteGet, null, false),
            new AttributeMetadata("avgNumNodesPrepare", "Average number of nodes in Prepare destination set", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumNodesPrepare, null, false),
            new AttributeMetadata("avgNumNodesRollback", "Average number of nodes in Rollback destination set", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumNodesRollback, null, false),
            new AttributeMetadata("localExecutionTimeWithoutLock", "Local execution time of a transaction without the time waiting for lock acquisition", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getLocalExecutionTimeWithoutLock, null, false),
            new AttributeMetadata("avgLockHoldTime", "Average lock holding time (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLockHoldTime, null, false),
            new AttributeMetadata("avgLocalLockHoldTime", "Average lock local holding time (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLocalLockHoldTime, null, false),
            new AttributeMetadata("avgRemoteLockHoldTime", "Average lock remote holding time (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteLockHoldTime, null, false),
            new AttributeMetadata("avgCommitTime", "Average local commit duration time (2nd phase only) (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgCommitTime, null, false),
            new AttributeMetadata("avgRollbackTime", "Average local rollback duration time (2nd phase only) (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRollbackTime, null, false),
            new AttributeMetadata("avgPrepareCommandSize", "Average prepare command size (in bytes)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgPrepareCommandSize, null, false),
            new AttributeMetadata("avgCommitCommandSize", "Average commit command size (in bytes)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgCommitCommandSize, null, false),
            new AttributeMetadata("avgClusteredGetCommandSize", "Average clustered get command size (in bytes)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgClusteredGetCommandSize, null, false),
            new AttributeMetadata("avgLockWaitingTime", "Average time waiting for the lock acquisition (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLockWaitingTime, null, false),
            new AttributeMetadata("avgTxArrivalRate", "Average transaction arrival rate, originated locally and remotely (in transaction per second)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgTxArrivalRate, null, false),
            new AttributeMetadata("percentageWriteTransactions", "Percentage of Write transaction executed locally (committed and aborted)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getPercentageWriteTransactions, null, false),
            new AttributeMetadata("percentageSuccessWriteTransactions", "Percentage of Write transaction executed in all successfully executed transactions (local transaction only)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getPercentageSuccessWriteTransactions, null, false),
            new AttributeMetadata("numAbortedTxDueTimeout", "The number of aborted transactions due to timeout in lock acquisition", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumAbortedTxDueTimeout, null, false),
            new AttributeMetadata("numAbortedTxDueDeadlock", "The number of aborted transactions due to deadlock", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumAbortedTxDueDeadlock, null, false),
            new AttributeMetadata("avgReadOnlyTxDuration", "Average successful read-only transaction duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgReadOnlyTxDuration, null, false),
            new AttributeMetadata("avgWriteTxDuration", "Average successful write transaction duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgWriteTxDuration, null, false),
            new AttributeMetadata("avgAbortedWriteTxDuration", "Average aborted write transaction duration (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgAbortedWriteTxDuration, null, false),
            new AttributeMetadata("avgNumOfLockLocalTx", "Average number of locks per write local transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumOfLockLocalTx, null, false),
            new AttributeMetadata("avgNumOfLockRemoteTx", "Average number of locks per write remote transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumOfLockRemoteTx, null, false),
            new AttributeMetadata("avgNumOfLockSuccessLocalTx", "Average number of locks per successfully write local transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgNumOfLockSuccessLocalTx, null, false),
            new AttributeMetadata("avgLocalPrepareTime", "Average time it takes to execute the prepare command locally (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLocalPrepareTime, null, false),
            new AttributeMetadata("avgRemotePrepareTime", "Average time it takes to execute the prepare command remotely (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemotePrepareTime, null, false),
            new AttributeMetadata("avgLocalCommitTime", "Average time it takes to execute the commit command locally (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLocalCommitTime, null, false),
            new AttributeMetadata("avgRemoteCommitTime", "Average time it takes to execute the commit command remotely (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteCommitTime, null, false),
            new AttributeMetadata("avgLocalRollbackTime", "Average time it takes to execute the rollback command locally (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLocalRollbackTime, null, false),
            new AttributeMetadata("avgRemoteRollbackTime", "Average time it takes to execute the rollback command remotely (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteRollbackTime, null, false),
            new AttributeMetadata("abortRate", "Abort Rate", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAbortRate, null, false),
            new AttributeMetadata("throughput", "Throughput (in transactions per second)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getThroughput, null, false),
            new AttributeMetadata("avgGetsPerROTransaction", "Average number of get operations per (local) read-only transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgGetsPerROTransaction, null, false),
            new AttributeMetadata("avgGetsPerWrTransaction", "Average number of get operations per (local) read-write transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgGetsPerWrTransaction, null, false),
            new AttributeMetadata("avgRemoteGetsPerWrTransaction", "Average number of remote get operations per (local) read-write transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteGetsPerWrTransaction, null, false),
            new AttributeMetadata("avgRemoteGetsPerROTransaction", "Average number of remote get operations per (local) read-only transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemoteGetsPerROTransaction, null, false),
            new AttributeMetadata("remoteGetExecutionTime", "Average cost of a remote get", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getRemoteGetExecutionTime, null, false),
            new AttributeMetadata("avgPutsPerWrTransaction", "Average number of put operations per (local) read-write transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgPutsPerWrTransaction, null, false),
            new AttributeMetadata("avgRemotePutsPerWrTransaction", "Average number of remote put operations per (local) read-write transaction", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgRemotePutsPerWrTransaction, null, false),
            new AttributeMetadata("remotePutExecutionTime", "Average cost of a remote put", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getRemotePutExecutionTime, null, false),
            new AttributeMetadata("numberOfGets", "Number of gets performed since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfGets, null, false),
            new AttributeMetadata("numberOfRemoteGets", "Number of remote gets performed since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfRemoteGets, null, false),
            new AttributeMetadata("numberOfPuts", "Number of puts performed since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfPuts, null, false),
            new AttributeMetadata("numberOfRemotePuts", "Number of remote puts performed since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfRemotePuts, null, false),
            new AttributeMetadata("numberOfCommits", "Number of committed transactions since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfCommits, null, false),
            new AttributeMetadata("numberOfLocalCommits", "Number of local committed transactions since last reset", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumberOfLocalCommits, null, false),
            new AttributeMetadata("writeSkewProbability", "Write skew probability", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getWriteSkewProbability, null, false),
            new AttributeMetadata("avgLocalGetTime", "Average Local processing Get time (in microseconds)", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgLocalGetTime, null, false),
            new AttributeMetadata("numNodes", "Number of nodes in the cluster", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getNumNodes, null, false),
            new AttributeMetadata("replicationDegree", "Number of replicas for each key", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getReplicationDegree, null, false),
            new AttributeMetadata("localActiveTransactions", "Number of concurrent transactions executing on the current node", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getLocalActiveTransactions, null, false),
            new AttributeMetadata("avgResponseTime", "Average Response Time", false, true, "double", false, (java.util.function.Function<org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor, ?>) org.infinispan.extendedstats.wrappers.ExtendedStatisticInterceptor::getAvgResponseTime, null, false),
            new AttributeMetadata("availableExtendedStatistics", "Returns all the available statistics", false, true, "java.lang.String", false, null, null, false),
            new OperationMetadata("getPercentileLocalReadOnlyTransaction", "", "K-th percentile of local read-only transactions execution time", "double",
               new OperationParameterMetadata("percentile", "int", "")
            ),
            new OperationMetadata("getPercentileRemoteReadOnlyTransaction", "", "K-th percentile of remote read-only transactions execution time", "double",
               new OperationParameterMetadata("percentile", "int", "")
            ),
            new OperationMetadata("getPercentileLocalRWriteTransaction", "", "K-th percentile of local write transactions execution time", "double",
               new OperationParameterMetadata("percentile", "int", "")
            ),
            new OperationMetadata("getPercentileRemoteWriteTransaction", "", "K-th percentile of remote write transactions execution time", "double",
               new OperationParameterMetadata("percentile", "int", "")
            ),
            new OperationMetadata("resetStatistics", "", "Reset all the statistics collected", "void"
            ),
            new OperationMetadata("getStatisticValue", "", "Returns the raw value for the statistic", "double",
               new OperationParameterMetadata("statName", "java.lang.String", "Statistic name")
            ),
            new OperationMetadata("dumpStatistics", "", "Dumps the current cache statistic values", "java.lang.String"
            ),
            new OperationMetadata("dumpStatisticsToSystemOut", "", "Dumps the current cache statistic values to System.out", "void"
            ),
            new OperationMetadata("dumpStatisticToFile", "", "Dumps the current cache statistic values to a file", "void",
               new OperationParameterMetadata("filePath", "java.lang.String", "The file path")
            )
      ));

//end
   }
}
