/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class OfflineStatus {
    private static Log log = LogFactory.getLog(OfflineStatus.class);
    private final TimeService timeService;
    private volatile TakeOfflineConfiguration takeOffline;
    private boolean recordingOfflineStatus = false;
    private long firstFailureTime;
    private int failureCount;
    private volatile boolean forceOffline = false;

    public OfflineStatus(TakeOfflineConfiguration takeOfflineConfiguration, TimeService timeService) {
        this.takeOffline = takeOfflineConfiguration;
        this.timeService = timeService;
    }

    public synchronized void updateOnCommunicationFailure(long sendTimeMillis) {
        if (!this.recordingOfflineStatus) {
            this.recordingOfflineStatus = true;
            this.firstFailureTime = sendTimeMillis;
        }
        ++this.failureCount;
    }

    public synchronized boolean isOffline() {
        if (this.forceOffline) {
            return true;
        }
        if (!this.recordingOfflineStatus) {
            return false;
        }
        if (this.takeOffline.minTimeToWait() > 0L && !this.minTimeHasElapsed()) {
            return false;
        }
        if (this.takeOffline.afterFailures() > 0) {
            return this.takeOffline.afterFailures() <= this.failureCount;
        }
        log.trace("Site is failed: minTimeToWait elapsed and we don't have a min failure number to wait for.");
        return true;
    }

    public synchronized boolean minTimeHasElapsed() {
        if (this.takeOffline.minTimeToWait() <= 0L) {
            throw new IllegalStateException("Cannot invoke this method if minTimeToWait is not enabled");
        }
        long millis = this.millisSinceFirstFailure();
        if (millis >= this.takeOffline.minTimeToWait()) {
            log.tracef("The minTimeToWait has passed: minTime=%s, timeSinceFirstFailure=%s", this.takeOffline.minTimeToWait(), millis);
            return true;
        }
        return false;
    }

    public synchronized long millisSinceFirstFailure() {
        return this.timeService.timeDuration(TimeUnit.MILLISECONDS.toNanos(this.firstFailureTime), TimeUnit.MILLISECONDS);
    }

    public synchronized boolean bringOnline() {
        if (!this.isOffline()) {
            return false;
        }
        this.reset();
        return true;
    }

    public synchronized int getFailureCount() {
        return this.failureCount;
    }

    public synchronized boolean isEnabled() {
        return this.takeOffline.enabled();
    }

    public void amend(TakeOfflineConfiguration takeOffline) {
        this.takeOffline = takeOffline;
        this.reset();
    }

    public void reset() {
        this.recordingOfflineStatus = false;
        this.failureCount = 0;
        this.forceOffline = false;
    }

    public TakeOfflineConfiguration getTakeOffline() {
        return this.takeOffline;
    }

    public boolean forceOffline() {
        if (this.isOffline()) {
            return false;
        }
        this.forceOffline = true;
        return true;
    }

    public String toString() {
        return "OfflineStatus{takeOffline=" + this.takeOffline + ", recordingOfflineStatus=" + this.recordingOfflineStatus + ", firstFailureTime=" + this.firstFailureTime + ", forceOffline=" + this.forceOffline + ", failureCount=" + this.failureCount + '}';
    }

    public void amend(Integer afterFailures, Long minTimeToWait) {
        TakeOfflineConfiguration existing = this.getTakeOffline();
        int newAfterFailures = afterFailures == null ? existing.afterFailures() : afterFailures.intValue();
        long newMinTieToWait = minTimeToWait == null ? existing.minTimeToWait() : minTimeToWait.longValue();
        TakeOfflineConfiguration newConfig = new TakeOfflineConfiguration(newAfterFailures, newMinTieToWait);
        this.amend(newConfig);
    }
}

