/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import javax.transaction.Transaction;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.AbstractInvocationContextFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;

@SurvivesRestarts
public class NonTransactionalInvocationContextFactory
extends AbstractInvocationContextFactory {
    @Override
    @Inject
    public void init(Configuration config) {
        super.init(config);
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        if (keyCount == 1) {
            return new SingleKeyNonTxInvocationContext(true, this.keyEq);
        }
        if (keyCount > 0) {
            return new NonTxInvocationContext(keyCount, true, (Equivalence<Object>)this.keyEq);
        }
        return this.createInvocationContext(null, false);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx, boolean implicitTransaction) {
        return this.createNonTxInvocationContext();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        NonTxInvocationContext ctx = new NonTxInvocationContext((Equivalence<Object>)this.keyEq);
        ctx.setOriginLocal(true);
        return ctx;
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        return new SingleKeyNonTxInvocationContext(true, this.keyEq);
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        NonTxInvocationContext ctx = new NonTxInvocationContext((Equivalence<Object>)this.keyEq);
        ctx.setOrigin(origin);
        return ctx;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext(LocalTransaction localTransaction) {
        throw this.exception();
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        throw this.exception();
    }

    private IllegalStateException exception() {
        return new IllegalStateException("This is a non-transactional cache - why need to build a transactional context for it!");
    }
}

