/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.concurrent.locks.StripedLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LockSupportCacheStore<L>
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(LockSupportCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private StripedLock locks;
    private long globalLockTimeoutMillis;
    private LockSupportCacheStoreConfig config;

    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (LockSupportCacheStoreConfig)config;
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        if (this.config == null) {
            throw new CacheLoaderException("Null config. Possible reason is not calling super.init(...)");
        }
        log.tracef("Starting cache with config: %s", this.config);
        this.locks = new StripedLock(this.config.getLockConcurrencyLevel());
        this.globalLockTimeoutMillis = this.config.getLockAcquistionTimeout();
    }

    protected final void unlock(L key) {
        this.locks.releaseLock(key);
    }

    protected final void lockForWriting(L key) {
        this.locks.acquireLock(key, true);
    }

    protected final void lockForReading(L key) {
        this.locks.acquireLock(key, false);
    }

    protected final void upgradeLock(L key) {
        this.locks.upgradeLock(key);
    }

    protected final void downgradeLock(L key) {
        this.locks.downgradeLock(key);
    }

    protected final boolean immediateLockForWriting(L key) {
        return this.locks.acquireLock(key, true, 0L);
    }

    protected final boolean acquireGlobalLock(boolean exclusive) {
        return this.locks.acquireGlobalLock(exclusive, this.globalLockTimeoutMillis);
    }

    protected final void releaseGlobalLock(boolean exclusive) {
        this.locks.releaseGlobalLock(exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InternalCacheEntry load(Object key) throws CacheLoaderException {
        L lockingKey = this.getLockFromKey(key);
        this.lockForReading(lockingKey);
        try {
            InternalCacheEntry internalCacheEntry = this.loadLockSafe(key, lockingKey);
            return internalCacheEntry;
        }
        finally {
            this.unlock(lockingKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        boolean success = this.acquireGlobalLock(false);
        try {
            Set<InternalCacheEntry> set = this.loadAllLockSafe();
            return set;
        }
        finally {
            if (success) {
                this.releaseGlobalLock(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<InternalCacheEntry> load(int maxEntries) throws CacheLoaderException {
        if (maxEntries < 0) {
            return this.loadAll();
        }
        boolean success = this.acquireGlobalLock(false);
        try {
            Set<InternalCacheEntry> set = this.loadLockSafe(maxEntries);
            return set;
        }
        finally {
            if (success) {
                this.releaseGlobalLock(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        boolean success = this.acquireGlobalLock(false);
        try {
            Set<Object> set = this.loadAllKeysLockSafe(keysToExclude);
            return set;
        }
        finally {
            if (success) {
                this.releaseGlobalLock(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void store(InternalCacheEntry ed) throws CacheLoaderException {
        if (trace) {
            log.tracef("store(%s)", ed);
        }
        if (ed == null) {
            return;
        }
        if (ed.canExpire() && ed.isExpired(System.currentTimeMillis())) {
            if (this.containsKey(ed.getKey())) {
                if (trace) {
                    log.tracef("Entry %s is expired!  Removing!", ed);
                }
                this.remove(ed.getKey());
            } else if (trace) {
                log.tracef("Entry %s is expired!  Not doing anything.", ed);
            }
            return;
        }
        L keyHashCode = this.getLockFromKey(ed.getKey());
        this.lockForWriting(keyHashCode);
        try {
            this.storeLockSafe(ed, keyHashCode);
        }
        finally {
            this.unlock(keyHashCode);
        }
        if (trace) {
            log.tracef("exit store(%s)", ed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object key) throws CacheLoaderException {
        if (trace) {
            log.tracef("remove(%s)", key);
        }
        L keyHashCode = this.getLockFromKey(key);
        try {
            this.lockForWriting(keyHashCode);
            boolean bl = this.removeLockSafe(key, keyHashCode);
            return bl;
        }
        finally {
            this.unlock(keyHashCode);
            if (trace) {
                log.tracef("Exit remove(%s)", key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fromStream(ObjectInput objectInput) throws CacheLoaderException {
        boolean success = this.acquireGlobalLock(true);
        try {
            this.fromStreamLockSafe(objectInput);
        }
        finally {
            if (success) {
                this.releaseGlobalLock(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toStream(ObjectOutput objectOutput) throws CacheLoaderException {
        boolean success = this.acquireGlobalLock(false);
        try {
            this.toStreamLockSafe(objectOutput);
        }
        finally {
            if (success) {
                this.releaseGlobalLock(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() throws CacheLoaderException {
        if (trace) {
            log.trace("Clearing store");
        }
        boolean success = this.acquireGlobalLock(true);
        try {
            this.clearLockSafe();
        }
        finally {
            if (success) {
                this.releaseGlobalLock(true);
            }
        }
    }

    public int getTotalLockCount() {
        return this.locks.getTotalLockCount();
    }

    protected abstract void clearLockSafe() throws CacheLoaderException;

    protected abstract Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException;

    protected abstract Set<InternalCacheEntry> loadLockSafe(int var1) throws CacheLoaderException;

    protected abstract Set<Object> loadAllKeysLockSafe(Set<Object> var1) throws CacheLoaderException;

    protected abstract void toStreamLockSafe(ObjectOutput var1) throws CacheLoaderException;

    protected abstract void fromStreamLockSafe(ObjectInput var1) throws CacheLoaderException;

    protected abstract boolean removeLockSafe(Object var1, L var2) throws CacheLoaderException;

    protected abstract void storeLockSafe(InternalCacheEntry var1, L var2) throws CacheLoaderException;

    protected abstract InternalCacheEntry loadLockSafe(Object var1, L var2) throws CacheLoaderException;

    protected abstract L getLockFromKey(Object var1) throws CacheLoaderException;
}

