/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.ClusteringInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Immutables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseDistributionInterceptor
extends ClusteringInterceptor {
    protected DistributionManager dm;
    protected ClusteringDependentLogic cdl;
    private static final Log log = LogFactory.getLog(BaseDistributionInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(DistributionManager distributionManager, ClusteringDependentLogic cdl) {
        this.dm = distributionManager;
        this.cdl = cdl;
    }

    @Override
    protected InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, FlagAffectedCommand command) throws Exception {
        GlobalTransaction gtx = acquireRemoteLock ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, command.getFlags(), acquireRemoteLock, gtx);
        ArrayList<Address> targets = new ArrayList<Address>(this.stateTransferManager.getCacheTopology().getReadConsistentHash().locateOwners(key));
        targets.retainAll(this.rpcManager.getTransport().getMembers());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, get, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.cacheConfiguration.clustering().sync().replTimeout(), true, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()), true, false);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false, false);
    }

    protected abstract Object handleWriteCommand(InvocationContext var1, WriteCommand var2, RecipientGenerator var3, boolean var4, boolean var5) throws Throwable;

    protected boolean isSingleOwnerAndLocal(RecipientGenerator recipientGenerator) {
        List<Address> recipients;
        return this.cacheConfiguration.clustering().hash().numOwners() == 1 && (recipients = recipientGenerator.generateRecipients()) != null && recipients.size() == 1 && recipients.get(0).equals(this.rpcManager.getTransport().getAddress());
    }

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        private final Collection<Object> keys;
        private List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                Set<Address> addresses = BaseDistributionInterceptor.this.dm.locateAll(this.keys);
                this.recipients = Immutables.immutableListConvert(addresses);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        private final Object key;
        private final Set<Object> keys;
        private List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = BaseDistributionInterceptor.this.dm.locate(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator
    extends KeyGenerator {
        public List<Address> generateRecipients();
    }

    static interface KeyGenerator {
        public Collection<Object> getKeys();
    }
}

