/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
implements PassivationManager {
    CacheLoaderManager cacheLoaderManager;
    CacheNotifier notifier;
    CacheStore cacheStore;
    Configuration cfg;
    boolean statsEnabled = false;
    boolean enabled = false;
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    private final AtomicLong passivations = new AtomicLong(0L);
    private DataContainer container;
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void inject(CacheLoaderManager cacheLoaderManager, CacheNotifier notifier, Configuration cfg, DataContainer container) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.notifier = notifier;
        this.cfg = cfg;
        this.container = container;
    }

    @Start(priority=11)
    public void start() {
        this.enabled = this.cacheLoaderManager.isUsingPassivation();
        if (this.enabled) {
            CacheStore cacheStore = this.cacheStore = this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheStore();
            if (this.cacheStore == null) {
                throw new ConfigurationException("passivation can only be used with a CacheLoader that implements CacheStore!");
            }
            this.enabled = this.cacheLoaderManager.isEnabled() && this.cacheLoaderManager.isUsingPassivation();
            this.statsEnabled = this.cfg.jmxStatistics().enabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void passivate(InternalCacheEntry entry) {
        if (this.enabled && entry != null) {
            Object key = entry.getKey();
            this.notifier.notifyCacheEntryPassivated(key, entry.getValue(), true, ImmutableContext.INSTANCE);
            if (trace) {
                log.tracef("Passivating entry %s", key);
            }
            try {
                this.cacheStore.store(entry);
                if (this.statsEnabled) {
                    this.passivations.getAndIncrement();
                }
            }
            catch (CacheLoaderException e) {
                log.unableToPassivateEntry(key, e);
            }
            this.notifier.notifyCacheEntryPassivated(key, null, false, ImmutableContext.INSTANCE);
        }
    }

    @Override
    @Stop(priority=9)
    public void passivateAll() throws CacheLoaderException {
        if (this.enabled) {
            long start = System.nanoTime();
            log.passivatingAllEntries();
            for (InternalCacheEntry e : this.container) {
                if (trace) {
                    log.tracef("Passivating %s", e.getKey());
                }
                this.cacheStore.store(e);
            }
            log.passivatedEntries(this.container.size(), Util.prettyPrintTime(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
    }

    @Override
    public long getPassivationCount() {
        return this.passivations.get();
    }

    @Override
    public void resetPassivationCount() {
        this.passivations.set(0L);
    }
}

