/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfiguration;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.util.TypedProperties;

public class ScheduledExecutorFactoryConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<ScheduledExecutorFactoryConfiguration> {
    private ScheduledExecutorFactory factory = new DefaultScheduledExecutorFactory();
    private Properties properties = new Properties();

    ScheduledExecutorFactoryConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public ScheduledExecutorFactoryConfigurationBuilder factory(ScheduledExecutorFactory factory) {
        this.factory = factory;
        return this;
    }

    public ScheduledExecutorFactoryConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ScheduledExecutorFactoryConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    ScheduledExecutorFactoryConfiguration create() {
        return new ScheduledExecutorFactoryConfiguration(this.factory, TypedProperties.toTypedProperties(this.properties));
    }

    public ScheduledExecutorFactoryConfigurationBuilder read(ScheduledExecutorFactoryConfiguration template) {
        this.factory = template.factory();
        this.properties = template.properties();
        return this;
    }

    public String toString() {
        return "ScheduledExecutorFactoryConfigurationBuilder{factory=" + this.factory + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledExecutorFactoryConfigurationBuilder that = (ScheduledExecutorFactoryConfigurationBuilder)o;
        if (this.factory != null ? !this.factory.equals(that.factory) : that.factory != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.factory != null ? this.factory.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

