/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.util.concurrent.IsolationLevel;

public class LockingConfiguration {
    private final int concurrencyLevel;
    private final IsolationLevel isolationLevel;
    private long lockAcquisitionTimeout;
    private final boolean useLockStriping;
    private final boolean writeSkewCheck;
    private boolean supportsConcurrentUpdates;

    LockingConfiguration(int concurrencyLevel, IsolationLevel isolationLevel, long lockAcquisitionTimeout, boolean useLockStriping, boolean writeSkewCheck, boolean supportsConcurrentUpdates) {
        this.concurrencyLevel = concurrencyLevel;
        this.isolationLevel = isolationLevel;
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        this.useLockStriping = useLockStriping;
        this.writeSkewCheck = writeSkewCheck;
        this.supportsConcurrentUpdates = supportsConcurrentUpdates;
    }

    public int concurrencyLevel() {
        return this.concurrencyLevel;
    }

    public boolean supportsConcurrentUpdates() {
        return this.supportsConcurrentUpdates;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    public long lockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout;
    }

    public LockingConfiguration lockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        return this;
    }

    public boolean useLockStriping() {
        return this.useLockStriping;
    }

    public boolean writeSkewCheck() {
        return this.writeSkewCheck;
    }

    public String toString() {
        return "LockingConfiguration{concurrencyLevel=" + this.concurrencyLevel + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + ", lockAcquisitionTimeout=" + this.lockAcquisitionTimeout + ", useLockStriping=" + this.useLockStriping + ", writeSkewCheck=" + this.writeSkewCheck + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockingConfiguration that = (LockingConfiguration)o;
        if (this.concurrencyLevel != that.concurrencyLevel) {
            return false;
        }
        if (this.lockAcquisitionTimeout != that.lockAcquisitionTimeout) {
            return false;
        }
        if (this.useLockStriping != that.useLockStriping) {
            return false;
        }
        if (this.writeSkewCheck != that.writeSkewCheck) {
            return false;
        }
        return this.isolationLevel == that.isolationLevel;
    }

    public int hashCode() {
        int result = this.concurrencyLevel;
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (int)(this.lockAcquisitionTimeout ^ this.lockAcquisitionTimeout >>> 32);
        result = 31 * result + (this.useLockStriping ? 1 : 0);
        result = 31 * result + (this.writeSkewCheck ? 1 : 0);
        return result;
    }
}

