/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.ConfigurationSchemaVersion;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.json.JsonConfigurationReader;
import org.infinispan.commons.configuration.io.xml.XmlConfigurationReader;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;

public interface ConfigurationReader
extends AutoCloseable {
    public static Builder from(InputStream is) {
        return new Builder(is);
    }

    public static Builder from(Reader reader) {
        return new Builder(reader);
    }

    public static Builder from(String s) {
        return new Builder(new StringReader(s));
    }

    public String getName();

    public ConfigurationResourceResolver getResourceResolver();

    public NamingStrategy getNamingStrategy();

    public void setSchema(ConfigurationSchemaVersion var1);

    public ConfigurationSchemaVersion getSchema();

    public ElementType nextElement();

    default public boolean inTag() {
        return this.hasNext() && this.nextElement() != ElementType.END_ELEMENT;
    }

    default public boolean inTag(String name) {
        return this.hasNext() && (this.nextElement() != ElementType.END_ELEMENT || !name.equals(this.getLocalName()));
    }

    default public boolean inTag(Enum<?> name) {
        return this.inTag(name.toString());
    }

    public Location getLocation();

    public Object getProperty(String var1);

    public Properties getProperties();

    public String getAttributeName(int var1);

    public String getAttributeName(int var1, NamingStrategy var2);

    public String getAttributeNamespace(int var1);

    public String getAttributeValue(String var1);

    default public String getAttributeValue(Enum<?> localName) {
        return this.getAttributeValue(localName.toString());
    }

    public String getAttributeValue(String var1, NamingStrategy var2);

    default public String getAttributeValue(Enum<?> localName, NamingStrategy strategy) {
        return this.getAttributeValue(localName.toString(), strategy);
    }

    public String getAttributeValue(int var1);

    default public String[] getListAttributeValue(int index) {
        return this.getAttributeValue(index).split("\\s+");
    }

    public String getElementText();

    public String getLocalName();

    public String getLocalName(NamingStrategy var1);

    public String getNamespace();

    public boolean hasNext();

    public int getAttributeCount();

    public void handleAny(ConfigurationReaderContext var1);

    public void handleAttribute(ConfigurationReaderContext var1, int var2);

    default public void require(ElementType type) {
        this.require(type, null, (String)null);
    }

    public void require(ElementType var1, String var2, String var3);

    default public void require(ElementType type, String namespace, Enum<?> name) {
        this.require(type, namespace, name.toString());
    }

    public Map.Entry<String, String> getMapItem(String var1);

    public Map.Entry<String, String> getMapItem(Enum<?> var1);

    public void endMapItem();

    public String[] readArray(Enum<?> var1, Enum<?> var2);

    public String[] readArray(String var1, String var2);

    public boolean hasFeature(ConfigurationFormatFeature var1);

    @Override
    public void close();

    public void setAttributeValue(String var1, String var2, String var3);

    default public void setAttributeValue(String namespace, Enum<?> localName, String value) {
        this.setAttributeValue(namespace, localName.toString(), value);
    }

    public static class Builder {
        private final BufferedReader reader;
        private MediaType type;
        private PropertyReplacer replacer = PropertyReplacer.DEFAULT;
        private Properties properties = new Properties();
        private ConfigurationResourceResolver resolver = ConfigurationResourceResolver.DEFAULT;
        private NamingStrategy namingStrategy = NamingStrategy.IDENTITY;

        private Builder(InputStream is) {
            this(new InputStreamReader(is));
        }

        private Builder(Reader reader) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        }

        public Builder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder withType(MediaType type) {
            this.type = type;
            return this;
        }

        public Builder withReplacer(PropertyReplacer replacer) {
            this.replacer = Objects.requireNonNull(replacer);
            return this;
        }

        public Builder withResolver(ConfigurationResourceResolver resolver) {
            this.resolver = Objects.requireNonNull(resolver);
            return this;
        }

        public Builder withNamingStrategy(NamingStrategy namingStrategy) {
            this.namingStrategy = Objects.requireNonNull(namingStrategy);
            return this;
        }

        private int firstChar() {
            try {
                this.reader.mark(16);
                int first = this.reader.read();
                this.reader.reset();
                return first;
            }
            catch (IOException e) {
                String name = null;
                URL context = this.resolver.getContext();
                if (context != null) {
                    name = context.getPath();
                }
                throw new ConfigurationReaderException(e, new Location(name, 1, 1));
            }
        }

        public ConfigurationReader build() {
            if (this.type == null) {
                int first = this.firstChar();
                switch (first) {
                    case 60: {
                        this.type = MediaType.APPLICATION_XML;
                        break;
                    }
                    case 123: {
                        this.type = MediaType.APPLICATION_JSON;
                        break;
                    }
                    default: {
                        this.type = MediaType.APPLICATION_YAML;
                    }
                }
            }
            switch (this.type.getTypeSubtype()) {
                case "application/xml": {
                    return new XmlConfigurationReader(this.reader, this.resolver, this.properties, this.replacer, this.namingStrategy);
                }
                case "application/yaml": {
                    return new YamlConfigurationReader(this.reader, this.resolver, this.properties, this.replacer, this.namingStrategy);
                }
                case "application/json": {
                    return new JsonConfigurationReader(this.reader, this.resolver, this.properties, this.replacer, this.namingStrategy);
                }
            }
            throw new IllegalArgumentException(this.type.toString());
        }
    }

    public static enum ElementType {
        START_DOCUMENT,
        END_DOCUMENT,
        START_ELEMENT,
        END_ELEMENT,
        TEXT;

    }
}

