/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.filter.Filters;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.impl.ContinuousQueryResult;

public final class ContinuousQueryImpl<K, V>
implements ContinuousQuery<K, V> {
    private final RemoteCache<K, V> cache;
    private final SerializationContext serializationContext;
    private final List<ClientEntryListener<K, ?>> listeners = new ArrayList();

    public ContinuousQueryImpl(RemoteCache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter cannot be null");
        }
        this.cache = cache;
        this.serializationContext = MarshallerUtil.getSerializationContext(cache.getRemoteCacheManager());
    }

    public <C> void addContinuousQueryListener(String queryString, ContinuousQueryListener<K, C> listener) {
        this.addContinuousQueryListener(queryString, null, listener);
    }

    public <C> void addContinuousQueryListener(String queryString, Map<String, Object> namedParameters, ContinuousQueryListener<K, C> listener) {
        ClientEntryListener<K, C> eventListener = new ClientEntryListener<K, C>(this.serializationContext, listener);
        Object[] factoryParams = Filters.makeFactoryParams(queryString, namedParameters);
        this.cache.addClientListener(eventListener, factoryParams, null);
        this.listeners.add(eventListener);
    }

    public <C> void addContinuousQueryListener(Query query, ContinuousQueryListener<K, C> listener) {
        this.addContinuousQueryListener(query.getQueryString(), query.getParameters(), listener);
    }

    public void removeContinuousQueryListener(ContinuousQueryListener<K, ?> listener) {
        Iterator<ClientEntryListener<K, ?>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ClientEntryListener<K, ?> l = it.next();
            if (((ClientEntryListener)l).listener != listener) continue;
            this.cache.removeClientListener(l);
            it.remove();
            break;
        }
    }

    public List<ContinuousQueryListener<K, ?>> getListeners() {
        ArrayList queryListeners = new ArrayList(this.listeners.size());
        for (ClientEntryListener<K, ?> l : this.listeners) {
            queryListeners.add(((ClientEntryListener)l).listener);
        }
        return queryListeners;
    }

    public void removeAllListeners() {
        for (ClientEntryListener<K, ?> l : this.listeners) {
            this.cache.removeClientListener(l);
        }
        this.listeners.clear();
    }

    @ClientListener(filterFactoryName="continuous-query-filter-converter-factory", converterFactoryName="continuous-query-filter-converter-factory", useRawData=true, includeCurrentState=true)
    private static final class ClientEntryListener<K, C> {
        private final SerializationContext serializationContext;
        private final ContinuousQueryListener<K, C> listener;

        ClientEntryListener(SerializationContext serializationContext, ContinuousQueryListener<K, C> listener) {
            this.serializationContext = serializationContext;
            this.listener = listener;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        @ClientCacheEntryRemoved
        @ClientCacheEntryExpired
        public void handleEvent(ClientCacheEntryCustomEvent<byte[]> event) throws IOException {
            byte[] eventData = event.getEventData();
            ContinuousQueryResult cqr = (ContinuousQueryResult)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])eventData);
            Object key = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])cqr.getKey());
            Object[] value = cqr.getValue() != null ? ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])cqr.getValue()) : cqr.getProjection();
            switch (cqr.getResultType()) {
                case JOINING: {
                    this.listener.resultJoining(key, (Object)value);
                    break;
                }
                case UPDATED: {
                    this.listener.resultUpdated(key, (Object)value);
                    break;
                }
                case LEAVING: {
                    this.listener.resultLeaving(key);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected result type : " + cqr.getResultType());
                }
            }
        }
    }
}

