/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.patterns.NodeTest;
import org.htmlunit.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            for (StepPattern m_pattern : this.m_patterns) {
                if (!m_pattern.canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (null != patterns) {
            for (StepPattern pattern : patterns) {
                pattern.exprSetParent(this);
            }
        }
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        for (StepPattern m_pattern : this.m_patterns) {
            XObject score = m_pattern.execute(xctxt);
            if (score == NodeTest.SCORE_NONE) continue;
            if (null == bestScore) {
                bestScore = score;
                continue;
            }
            if (!(score.num() > bestScore.num())) continue;
            bestScore = score;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        visitor.visitUnionPattern();
        if (null != this.m_patterns) {
            for (StepPattern m_pattern : this.m_patterns) {
                m_pattern.callVisitors(visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == up.m_patterns || up.m_patterns.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_patterns[i].deepEquals(up.m_patterns[i])) continue;
                return false;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }
}

