/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath;

import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.DTMIterator;
import org.htmlunit.xpath.xml.dtm.DTMManager;
import org.htmlunit.xpath.xml.utils.NodeVector;

public class NodeSetDTM
extends NodeVector
implements DTMIterator,
Cloneable {
    final DTMManager m_manager;
    protected transient int m_next = 0;
    protected transient boolean m_cacheNodes = true;
    protected int m_root = -1;

    public NodeSetDTM(DTMManager dtmManager) {
        this.m_manager = dtmManager;
    }

    public NodeSetDTM(DTMIterator ni) {
        this.m_manager = ni.getDTMManager();
        this.m_root = ni.getRoot();
        this.addNodes(ni);
    }

    @Override
    public int getRoot() {
        if (-1 == this.m_root) {
            if (this.size() > 0) {
                return this.item(0);
            }
            return -1;
        }
        return this.m_root;
    }

    @Override
    public void setRoot(int context, Object environment) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSetDTM clone = (NodeSetDTM)this.clone();
        clone.reset();
        return clone;
    }

    @Override
    public void reset() {
        this.m_next = 0;
    }

    @Override
    public int getWhatToShow() {
        return -17;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return true;
    }

    @Override
    public DTM getDTM(int nodeHandle) {
        return this.m_manager.getDTM(nodeHandle);
    }

    @Override
    public DTMManager getDTMManager() {
        return this.m_manager;
    }

    @Override
    public int nextNode() {
        if (this.m_next < this.size()) {
            int next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return -1;
    }

    @Override
    public int previousNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return -1;
    }

    @Override
    public void detach() {
    }

    @Override
    public boolean isFresh() {
        return this.m_next == 0;
    }

    @Override
    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    @Override
    public int item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    @Override
    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(int n) {
        this.addElement(n);
    }

    public void addNodes(DTMIterator iterator) {
        if (null != iterator) {
            int obj;
            while (-1 != (obj = iterator.nextNode())) {
                this.addElement(obj);
            }
        }
    }

    public void addNodeInDocOrder(int node, boolean test, XPathContext support) {
        int insertIndex = -1;
        if (test) {
            int i;
            int size = this.size();
            for (i = size - 1; i >= 0; --i) {
                int child = this.elementAt(i);
                if (child == node) {
                    i = -2;
                    break;
                }
                DTM dtm = support.getDTM(node);
                if (!dtm.isNodeAfter(node, child)) break;
            }
            if (i != -2) {
                insertIndex = i + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            for (int i = 0; i < insertIndex; ++i) {
                if (i != node) continue;
                foundit = true;
                break;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
    }

    public void addNodeInDocOrder(int node, XPathContext support) {
        this.addNodeInDocOrder(node, true, support);
    }

    @Override
    public int elementAt(int i) {
        this.runTo(i);
        return super.elementAt(i);
    }

    @Override
    public boolean contains(int s) {
        this.runTo(-1);
        return super.contains(s);
    }

    @Override
    public int indexOf(int elem, int index) {
        this.runTo(-1);
        return super.indexOf(elem, index);
    }

    @Override
    public int indexOf(int elem) {
        this.runTo(-1);
        return super.indexOf(elem);
    }

    @Override
    public int getCurrentPos() {
        return this.m_next;
    }

    @Override
    public void setCurrentPos(int i) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = i;
    }

    @Override
    public int getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        int current = this.m_next > 0 ? this.m_next - 1 : this.m_next;
        int n = current < this.m_firstFree ? this.elementAt(current) : -1;
        this.m_next = saved;
        return n;
    }

    @Override
    public void setShouldCacheNodes(boolean b) {
        if (!this.isFresh()) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = b;
    }

    @Override
    public boolean isDocOrdered() {
        return true;
    }

    @Override
    public int getAxis() {
        return -1;
    }
}

