/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalFileImpl;
import org.hornetq.core.journal.impl.JournalFilesRepository;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;
import org.hornetq.utils.ConcurrentHashSet;

public abstract class AbstractJournalUpdateTask
implements JournalReaderCallback {
    protected static final String FILE_COMPACT_CONTROL = "journal-rename-control.ctr";
    protected final JournalImpl journal;
    protected final SequentialFileFactory fileFactory;
    protected JournalFile currentFile;
    protected SequentialFile sequentialFile;
    protected final JournalFilesRepository filesRepository;
    protected long nextOrderingID;
    private HornetQBuffer writingChannel;
    private final Set<Long> recordsSnapshot = new ConcurrentHashSet();
    protected final List<JournalFile> newDataFiles = new ArrayList<JournalFile>();

    protected AbstractJournalUpdateTask(SequentialFileFactory fileFactory, JournalImpl journal, JournalFilesRepository filesRepository, Set<Long> recordsSnapshot, long nextOrderingID) {
        this.journal = journal;
        this.filesRepository = filesRepository;
        this.fileFactory = fileFactory;
        this.nextOrderingID = nextOrderingID;
        this.recordsSnapshot.addAll(recordsSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequentialFile writeControlFile(SequentialFileFactory fileFactory, List<JournalFile> files, List<JournalFile> newFiles, List<Pair<String, String>> renames) throws Exception {
        SequentialFile controlFile = fileFactory.createSequentialFile(FILE_COMPACT_CONTROL, 1);
        try {
            controlFile.open(1, false);
            JournalImpl.initFileHeader(fileFactory, controlFile, 0, 0L);
            HornetQBuffer filesToRename = HornetQBuffers.dynamicBuffer((int)1);
            if (files == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(files.size());
                for (JournalFile journalFile : files) {
                    filesToRename.writeUTF(journalFile.getFile().getFileName());
                }
            }
            if (newFiles == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(newFiles.size());
                for (JournalFile journalFile : newFiles) {
                    filesToRename.writeUTF(journalFile.getFile().getFileName());
                }
            }
            if (renames == null) {
                filesToRename.writeInt(0);
            } else {
                filesToRename.writeInt(renames.size());
                for (Pair pair : renames) {
                    filesToRename.writeUTF((String)pair.getA());
                    filesToRename.writeUTF((String)pair.getB());
                }
            }
            JournalAddRecord controlRecord = new JournalAddRecord(true, 1L, 0, new ByteArrayEncoding(filesToRename.toByteBuffer().array()));
            HornetQBuffer hornetQBuffer = HornetQBuffers.dynamicBuffer((int)filesToRename.writerIndex());
            controlRecord.setFileID(0);
            controlRecord.encode(hornetQBuffer);
            ByteBuffer writeBuffer = fileFactory.newBuffer(hornetQBuffer.writerIndex());
            writeBuffer.put(hornetQBuffer.toByteBuffer().array(), 0, hornetQBuffer.writerIndex());
            writeBuffer.rewind();
            controlFile.writeDirect(writeBuffer, true);
            SequentialFile sequentialFile = controlFile;
            return sequentialFile;
        }
        finally {
            controlFile.close();
        }
    }

    public void flush() throws Exception {
        if (this.writingChannel != null) {
            this.sequentialFile.position(0L);
            this.writingChannel.writerIndex(this.writingChannel.capacity());
            this.sequentialFile.writeInternal(this.writingChannel.toByteBuffer());
            this.sequentialFile.close();
            this.newDataFiles.add(this.currentFile);
        }
        this.writingChannel = null;
    }

    public boolean lookupRecord(long id) {
        return this.recordsSnapshot.contains(id);
    }

    protected void openFile() throws Exception {
        this.flush();
        ByteBuffer bufferWrite = this.fileFactory.newBuffer(this.journal.getFileSize());
        this.writingChannel = HornetQBuffers.wrappedBuffer((ByteBuffer)bufferWrite);
        this.currentFile = this.filesRepository.takeFile(false, false, false, true);
        this.sequentialFile = this.currentFile.getFile();
        this.sequentialFile.open(1, false);
        this.currentFile = new JournalFileImpl(this.sequentialFile, this.nextOrderingID++, 2);
        JournalImpl.writeHeader(this.writingChannel, this.journal.getUserVersion(), this.currentFile.getFileID());
    }

    protected void addToRecordsSnaptshot(long id) {
        this.recordsSnapshot.add(id);
    }

    protected HornetQBuffer getWritingChannel() {
        return this.writingChannel;
    }

    protected void writeEncoder(JournalInternalRecord record) throws Exception {
        record.setFileID(this.currentFile.getRecordID());
        record.encode(this.getWritingChannel());
    }

    protected void writeEncoder(JournalInternalRecord record, int txcounter) throws Exception {
        record.setNumberOfRecords(txcounter);
        this.writeEncoder(record);
    }
}

