/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.univariate;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.nonlinear.scalar.GoalType;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;

public class BracketFinder {
    private static final double EPS_MIN = 1.0E-21;
    private static final double GOLD = 1.618034;
    private final double growLimit;
    private final int maxEvaluations;
    private int evaluations;
    private double lo;
    private double hi;
    private double mid;
    private double fLo;
    private double fHi;
    private double fMid;

    public BracketFinder() {
        this(100.0, 500);
    }

    public BracketFinder(double growLimit, int maxEvaluations) {
        if (growLimit <= 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{growLimit, 0});
        }
        if (maxEvaluations <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{maxEvaluations, 0});
        }
        this.growLimit = growLimit;
        this.maxEvaluations = maxEvaluations;
    }

    public void search(UnivariateFunction func, GoalType goal, double xA, double xB) {
        FunctionEvaluator eval = new FunctionEvaluator(func);
        boolean isMinim = goal == GoalType.MINIMIZE;
        double fA = eval.value(xA);
        double fB = eval.value(xB);
        if (isMinim ? fA < fB : fA > fB) {
            double tmp = xA;
            xA = xB;
            xB = tmp;
            tmp = fA;
            fA = fB;
            fB = tmp;
        }
        double xC = xB + 1.618034 * (xB - xA);
        double fC = eval.value(xC);
        while (isMinim ? fC < fB : fC > fB) {
            double fW;
            double tmp1 = (xB - xA) * (fB - fC);
            double tmp2 = (xB - xC) * (fB - fA);
            double val = tmp2 - tmp1;
            double denom = FastMath.abs((double)val) < 1.0E-21 ? 2.0E-21 : 2.0 * val;
            double w = xB - ((xB - xC) * tmp2 - (xB - xA) * tmp1) / denom;
            double wLim = xB + this.growLimit * (xC - xB);
            if ((w - xC) * (xB - w) > 0.0) {
                fW = eval.value(w);
                if (isMinim ? fW < fC : fW > fC) {
                    xA = xB;
                    xB = w;
                    fA = fB;
                    fB = fW;
                    break;
                }
                if (isMinim ? fW > fB : fW < fB) {
                    xC = w;
                    fC = fW;
                    break;
                }
                w = xC + 1.618034 * (xC - xB);
                fW = eval.value(w);
            } else if ((w - wLim) * (wLim - xC) >= 0.0) {
                w = wLim;
                fW = eval.value(w);
            } else if ((w - wLim) * (xC - w) > 0.0) {
                fW = eval.value(w);
                if (isMinim ? fW < fC : fW > fC) {
                    xB = xC;
                    xC = w;
                    w = xC + 1.618034 * (xC - xB);
                    fB = fC;
                    fC = fW;
                    fW = eval.value(w);
                }
            } else {
                w = xC + 1.618034 * (xC - xB);
                fW = eval.value(w);
            }
            xA = xB;
            fA = fB;
            xB = xC;
            fB = fC;
            xC = w;
            fC = fW;
        }
        this.lo = xA;
        this.fLo = fA;
        this.mid = xB;
        this.fMid = fB;
        this.hi = xC;
        this.fHi = fC;
        if (this.lo > this.hi) {
            double tmp = this.lo;
            this.lo = this.hi;
            this.hi = tmp;
            tmp = this.fLo;
            this.fLo = this.fHi;
            this.fHi = tmp;
        }
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public double getLo() {
        return this.lo;
    }

    public double getFLo() {
        return this.fLo;
    }

    public double getHi() {
        return this.hi;
    }

    public double getFHi() {
        return this.fHi;
    }

    public double getMid() {
        return this.mid;
    }

    public double getFMid() {
        return this.fMid;
    }

    private class FunctionEvaluator {
        private final UnivariateFunction func;
        private final Incrementor inc;

        FunctionEvaluator(UnivariateFunction func) {
            this.func = func;
            this.inc = new Incrementor(BracketFinder.this.maxEvaluations);
            BracketFinder.this.evaluations = 0;
        }

        double value(double x) {
            this.inc.increment();
            BracketFinder.this.evaluations = this.inc.getCount();
            return this.func.value(x);
        }
    }
}

