/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.nonlinear.vector.constrained.BoundedConstraint;

public class LinearBoundedConstraint
extends BoundedConstraint
implements OptimizationData {
    private final RealMatrix a;

    public LinearBoundedConstraint(RealMatrix a, RealVector lower, RealVector upper) {
        super(lower, upper);
        this.a = a;
    }

    public LinearBoundedConstraint(double[][] a, double[] lower, double[] upper) {
        this((RealMatrix)new Array2DRowRealMatrix(a), (RealVector)new ArrayRealVector(lower), (RealVector)new ArrayRealVector(upper));
    }

    @Override
    public double[] value(double[] x) {
        return this.a.operate(x);
    }

    @Override
    public int dim() {
        return this.a.getColumnDimension();
    }

    @Override
    public RealVector value(RealVector x) {
        return this.a.operate(x);
    }

    @Override
    public RealMatrix jacobian(RealVector x) {
        return this.a.copy();
    }
}

