/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaStateInterpolator;

public class ThreeEighthesStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;

    public ThreeEighthesStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ThreeEighthesStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new ThreeEighthesStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double coeffDot3 = 0.75 * theta;
        double coeffDot1 = coeffDot3 * (4.0 * theta - 5.0) + 1.0;
        double coeffDot2 = coeffDot3 * (5.0 - 6.0 * theta);
        double coeffDot4 = coeffDot3 * (2.0 * theta - 1.0);
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double s = thetaH / 8.0;
            double fourTheta2 = 4.0 * theta * theta;
            double coeff1 = s * (8.0 - 15.0 * theta + 2.0 * fourTheta2);
            double coeff2 = 3.0 * s * (5.0 * theta - fourTheta2);
            double coeff3 = 3.0 * s * theta;
            double coeff4 = s * (-3.0 * theta + fourTheta2);
            interpolatedState = this.previousStateLinearCombination(coeff1, coeff2, coeff3, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2, coeffDot3, coeffDot4);
        } else {
            double s = oneMinusThetaH / -8.0;
            double fourTheta2 = 4.0 * theta * theta;
            double coeff1 = s * (1.0 - 7.0 * theta + 2.0 * fourTheta2);
            double coeff2 = 3.0 * s * (1.0 + theta - fourTheta2);
            double coeff3 = 3.0 * s * (1.0 + theta);
            double coeff4 = s * (1.0 + theta + fourTheta2);
            interpolatedState = this.currentStateLinearCombination(coeff1, coeff2, coeff3, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot2, coeffDot3, coeffDot4);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

