/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaFieldStateInterpolator;

public class LutherFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    private final T c5a;
    private final T c5b;
    private final T c5c;
    private final T c5d;
    private final T c6a;
    private final T c6b;
    private final T c6c;
    private final T c6d;
    private final T d5a;
    private final T d5b;
    private final T d5c;
    private final T d6a;
    private final T d6b;
    private final T d6c;

    public LutherFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(21.0)).sqrt();
        this.c5a = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-49)).add(-49.0);
        this.c5b = (CalculusFieldElement)((CalculusFieldElement)q.multiply(287)).add(392.0);
        this.c5c = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-357)).add(-637.0);
        this.c5d = (CalculusFieldElement)((CalculusFieldElement)q.multiply(343)).add(833.0);
        this.c6a = (CalculusFieldElement)((CalculusFieldElement)q.multiply(49)).add(-49.0);
        this.c6b = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-287)).add(392.0);
        this.c6c = (CalculusFieldElement)((CalculusFieldElement)q.multiply(357)).add(-637.0);
        this.c6d = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-343)).add(833.0);
        this.d5a = (CalculusFieldElement)((CalculusFieldElement)q.multiply(49)).add(49.0);
        this.d5b = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-847)).add(-1372.0);
        this.d5c = (CalculusFieldElement)((CalculusFieldElement)q.multiply(1029)).add(2254.0);
        this.d6a = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-49)).add(49.0);
        this.d6b = (CalculusFieldElement)((CalculusFieldElement)q.multiply(847)).add(-1372.0);
        this.d6c = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-1029)).add(2254.0);
    }

    @Override
    protected LutherFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new LutherFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        CalculusFieldElement coeffDot1 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(21)).add(-47.0)))).add(36.0)))).add(-10.8)))).add(1.0);
        CalculusFieldElement coeffDot2 = (CalculusFieldElement)time.getField().getZero();
        CalculusFieldElement coeffDot3 = (CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(112)).add(-202.66666666666666)))).add(106.66666666666667)))).add(-13.866666666666667)));
        CalculusFieldElement coeffDot4 = (CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-113.4)).add(194.4)))).add(-97.2)))).add(12.96)));
        CalculusFieldElement coeffDot5 = (CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.c5a.divide(5.0)))).add((FieldElement)((CalculusFieldElement)this.c5b.divide(15.0)))))).add((FieldElement)((CalculusFieldElement)this.c5c.divide(30.0)))))).add((FieldElement)((CalculusFieldElement)this.c5d.divide(150.0)))));
        CalculusFieldElement coeffDot6 = (CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.c6a.divide(5.0)))).add((FieldElement)((CalculusFieldElement)this.c6b.divide(15.0)))))).add((FieldElement)((CalculusFieldElement)this.c6c.divide(30.0)))))).add((FieldElement)((CalculusFieldElement)this.c6d.divide(150.0)))));
        CalculusFieldElement coeffDot7 = (CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(3.0)).add(-3.0)))).add(0.6)));
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            T s = thetaH;
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(4.2)).add(-11.75)))).add(12.0)))).add(-5.4)))).add(1.0)));
            CalculusFieldElement coeff2 = (CalculusFieldElement)time.getField().getZero();
            CalculusFieldElement coeff3 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(22.4)).add(-50.666666666666664)))).add(35.55555555555556)))).add(-6.933333333333334)))));
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-22.68)).add(48.6)))).add(-32.4)))).add(6.48)))));
            CalculusFieldElement coeff5 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.c5a.divide(25.0)))).add((FieldElement)((CalculusFieldElement)this.c5b.divide(60.0)))))).add((FieldElement)((CalculusFieldElement)this.c5c.divide(90.0)))))).add((FieldElement)((CalculusFieldElement)this.c5d.divide(300.0)))))));
            CalculusFieldElement coeff6 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.c6a.divide(25.0)))).add((FieldElement)((CalculusFieldElement)this.c6b.divide(60.0)))))).add((FieldElement)((CalculusFieldElement)this.c6c.divide(90.0)))))).add((FieldElement)((CalculusFieldElement)this.c6d.divide(300.0)))))));
            CalculusFieldElement coeff7 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(0.75)).add(-1.0)))).add(0.3)))));
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4, coeffDot5, coeffDot6, coeffDot7});
        } else {
            T s = oneMinusThetaH;
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-4.2)).add(7.55)))).add(-4.45)))).add(0.95)))).add(-0.05)));
            CalculusFieldElement coeff2 = (CalculusFieldElement)time.getField().getZero();
            CalculusFieldElement coeff3 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-22.4)).add(28.266666666666666)))).add(-7.288888888888889)))).add(-0.35555555555555557)))).add(-0.35555555555555557)));
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(22.68)).add(-25.92)))).add(6.48)))))));
            CalculusFieldElement coeff5 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.d5a.divide(25.0)))).add((FieldElement)((CalculusFieldElement)this.d5b.divide(300.0)))))).add((FieldElement)((CalculusFieldElement)this.d5c.divide(900.0)))))).add(-0.2722222222222222)))).add(-0.2722222222222222)));
            CalculusFieldElement coeff6 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)this.d6a.divide(25.0)))).add((FieldElement)((CalculusFieldElement)this.d6b.divide(300.0)))))).add((FieldElement)((CalculusFieldElement)this.d6c.divide(900.0)))))).add(-0.2722222222222222)))).add(-0.2722222222222222)));
            CalculusFieldElement coeff7 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(-0.75)).add(0.25)))).add(-0.05)))).add(-0.05)));
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4, coeff5, coeff6, coeff7});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4, coeffDot5, coeffDot6, coeffDot7});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

