/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.FieldExplicitRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.ode.nonstiff.interpolators.DormandPrince853FieldStateInterpolator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class DormandPrince853FieldIntegrator<T extends CalculusFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    public static final String METHOD_NAME = "Dormand-Prince 8 (5, 3)";

    public DormandPrince853FieldIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, METHOD_NAME, 12, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public DormandPrince853FieldIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, METHOD_NAME, 12, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement sqrt6 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).newInstance(6.0)).sqrt();
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)15);
        c[0] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-67.5);
        c[1] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-45.0);
        c[2] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-30.0);
        c[3] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(6.0)).divide(30.0);
        c[4] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 3);
        c[5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 4);
        c[6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 4, 13);
        c[7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 127, 195);
        c[8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3, 5);
        c[9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 6, 7);
        c[10] = (CalculusFieldElement)this.getField().getOne();
        c[11] = (CalculusFieldElement)this.getField().getOne();
        c[12] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.0, 10.0);
        c[13] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.0, 5.0);
        c[14] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 7.0, 9.0);
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement sqrt6 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).newInstance(6.0)).sqrt();
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)15, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-67.5);
        a[1][0] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-180.0);
        a[1][1] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-60.0);
        a[2][0] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-120.0);
        a[2][1] = (CalculusFieldElement)this.getField().getZero();
        a[2][2] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-6.0)).divide(-40.0);
        a[3][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(107)).add(462.0)).divide(3000.0);
        a[3][1] = (CalculusFieldElement)this.getField().getZero();
        a[3][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(197)).add(402.0)).divide(-1000.0);
        a[3][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(73)).add(168.0)).divide(375.0);
        a[4][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 27);
        a[4][1] = (CalculusFieldElement)this.getField().getZero();
        a[4][2] = (CalculusFieldElement)this.getField().getZero();
        a[4][3] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(16.0)).divide(108.0);
        a[4][4] = (CalculusFieldElement)((CalculusFieldElement)sqrt6.add(-16.0)).divide(-108.0);
        a[5][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 19, 512);
        a[5][1] = (CalculusFieldElement)this.getField().getZero();
        a[5][2] = (CalculusFieldElement)this.getField().getZero();
        a[5][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(23)).add(118.0)).divide(1024.0);
        a[5][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-23)).add(118.0)).divide(1024.0);
        a[5][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -9, 512);
        a[6][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 13772, 371293);
        a[6][1] = (CalculusFieldElement)this.getField().getZero();
        a[6][2] = (CalculusFieldElement)this.getField().getZero();
        a[6][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(4784)).add(51544.0)).divide(371293.0);
        a[6][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-4784)).add(51544.0)).divide(371293.0);
        a[6][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -5688, 371293);
        a[6][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3072, 371293);
        a[7][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5.8656157643E10, 9.3983540625E10);
        a[7][1] = (CalculusFieldElement)this.getField().getZero();
        a[7][2] = (CalculusFieldElement)this.getField().getZero();
        a[7][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-3.18801444819E11)).add(-1.324889724104E12)).divide(6.265569375E11);
        a[7][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(3.18801444819E11)).add(-1.324889724104E12)).divide(6.265569375E11);
        a[7][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 9.6044563816E10, 3.480871875E9);
        a[7][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5.682451879168E12, 2.81950621875E11);
        a[7][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.65125654E8, 3796875.0);
        a[8][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 8909899.0, 1.8653125E7);
        a[8][1] = (CalculusFieldElement)this.getField().getZero();
        a[8][2] = (CalculusFieldElement)this.getField().getZero();
        a[8][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-1137963.0)).add(-4521408.0)).divide(2937500.0);
        a[8][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(1137963.0)).add(-4521408.0)).divide(2937500.0);
        a[8][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 9.6663078E7, 4553125.0);
        a[8][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2.107245056E9, 1.37915625E8);
        a[8][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4.913652016E9, 1.47609375E8);
        a[8][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -7.889427E7, 3.880452869E9);
        a[9][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.0401265806E10, 2.1769653311E10);
        a[9][1] = (CalculusFieldElement)this.getField().getZero();
        a[9][2] = (CalculusFieldElement)this.getField().getZero();
        a[9][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(94326.0)).add(354216.0)).divide(112847.0);
        a[9][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-94326.0)).add(354216.0)).divide(112847.0);
        a[9][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4.3306765128E10, 5.313852383E9);
        a[9][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.0866708358144E13, 1.126708119789E12);
        a[9][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.488600343802E13, 6.54632330667E11);
        a[9][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3.5290686222309376E16, 1.4152473387134412E16);
        a[9][9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.477884375E9, 4.85066827E8);
        a[10][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3.9815761E7, 1.7514443E7);
        a[10][1] = (CalculusFieldElement)this.getField().getZero();
        a[10][2] = (CalculusFieldElement)this.getField().getZero();
        a[10][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(-960905.0)).add(-3457480.0)).divide(551636.0);
        a[10][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt6.multiply(960905.0)).add(-3457480.0)).divide(551636.0);
        a[10][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -8.44554132E8, 4.7026969E7);
        a[10][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 8.444996352E9, 3.02158619E8);
        a[10][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.509602342E9, 8.77790785E8);
        a[10][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.838879529799625E16, 3.199510091356783E15);
        a[10][9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2.2671625E8, 1.8341897E7);
        a[10][10] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.371316744E9, 2.131383595E9);
        a[11][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 104257.0, 1920240.0);
        a[11][1] = (CalculusFieldElement)this.getField().getZero();
        a[11][2] = (CalculusFieldElement)this.getField().getZero();
        a[11][3] = (CalculusFieldElement)this.getField().getZero();
        a[11][4] = (CalculusFieldElement)this.getField().getZero();
        a[11][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3399327.0, 763840.0);
        a[11][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 6.6578432E7, 3.5198415E7);
        a[11][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.674902723E9, 2.887164E8);
        a[11][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5.4980371265625E13, 1.76692375811392E14);
        a[11][9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -734375.0, 4826304.0);
        a[11][10] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.71414593E8, 8.512614E8);
        a[11][11] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 137909.0, 3084480.0);
        a[12][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.3481885573E10, 2.4003E11);
        a[12][1] = (CalculusFieldElement)this.getField().getZero();
        a[12][2] = (CalculusFieldElement)this.getField().getZero();
        a[12][3] = (CalculusFieldElement)this.getField().getZero();
        a[12][4] = (CalculusFieldElement)this.getField().getZero();
        a[12][5] = (CalculusFieldElement)this.getField().getZero();
        a[12][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.39418837528E11, 5.49975234375E11);
        a[12][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.1108320068443E13, 4.51119375E13);
        a[12][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.769651421925959E15, 1.424938514608E16);
        a[12][9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5.7799439E7, 3.77055E8);
        a[12][10] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 7.93322643029E11, 9.673425E13);
        a[12][11] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.458939311E9, 1.9278E11);
        a[12][12] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4149.0, 500000.0);
        a[13][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.595561272731E12, 5.01202735E13);
        a[13][1] = (CalculusFieldElement)this.getField().getZero();
        a[13][2] = (CalculusFieldElement)this.getField().getZero();
        a[13][3] = (CalculusFieldElement)this.getField().getZero();
        a[13][4] = (CalculusFieldElement)this.getField().getZero();
        a[13][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 9.75183916491E11, 3.445768803125E13);
        a[13][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3.8492013932672E13, 7.18912673015625E14);
        a[13][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.114881286517557E15, 2.02987107675E16);
        a[13][8] = (CalculusFieldElement)this.getField().getZero();
        a[13][9] = (CalculusFieldElement)this.getField().getZero();
        a[13][10] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.538710946863E12, 2.343122786125E16);
        a[13][11] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 8.824659001E9, 2.306671678125E13);
        a[13][12] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.1518334563E10, 3.38311846125E13);
        a[13][13] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.912306948E9, 1.3532473845E10);
        a[14][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.3613986967E10, 3.1741908048E10);
        a[14][1] = (CalculusFieldElement)this.getField().getZero();
        a[14][2] = (CalculusFieldElement)this.getField().getZero();
        a[14][3] = (CalculusFieldElement)this.getField().getZero();
        a[14][4] = (CalculusFieldElement)this.getField().getZero();
        a[14][5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -4.755612631E9, 1.012344804E9);
        a[14][6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 4.2939257944576E13, 5.588559685701E12);
        a[14][7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 7.7881972900277E13, 1.9140370552944E13);
        a[14][8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2.2719829234375E13, 6.3689648654052E13);
        a[14][9] = (CalculusFieldElement)this.getField().getZero();
        a[14][10] = (CalculusFieldElement)this.getField().getZero();
        a[14][11] = (CalculusFieldElement)this.getField().getZero();
        a[14][12] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.199007803E9, 8.57031517296E11);
        a[14][13] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.57882067E11, 5.3564469831E10);
        a[14][14] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -2.90468882375E11, 3.1741908048E10);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)16);
        b[0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 104257, 1920240);
        b[1] = (CalculusFieldElement)this.getField().getZero();
        b[2] = (CalculusFieldElement)this.getField().getZero();
        b[3] = (CalculusFieldElement)this.getField().getZero();
        b[4] = (CalculusFieldElement)this.getField().getZero();
        b[5] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3399327.0, 763840.0);
        b[6] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 6.6578432E7, 3.5198415E7);
        b[7] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -1.674902723E9, 2.887164E8);
        b[8] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 5.4980371265625E13, 1.76692375811392E14);
        b[9] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), -734375.0, 4826304.0);
        b[10] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1.71414593E8, 8.512614E8);
        b[11] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 137909.0, 3084480.0);
        b[12] = (CalculusFieldElement)this.getField().getZero();
        b[13] = (CalculusFieldElement)this.getField().getZero();
        b[14] = (CalculusFieldElement)this.getField().getZero();
        b[15] = (CalculusFieldElement)this.getField().getZero();
        return b;
    }

    @Override
    protected DormandPrince853FieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new DormandPrince853FieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }

    @Override
    public int getOrder() {
        return 8;
    }

    @Override
    protected double estimateError(T[][] yDotK, T[] y0, T[] y1, T h) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error1 = 0.0;
        double error2 = 0.0;
        for (int j = 0; j < helper.getMainSetDimension(); ++j) {
            double errSum1 = 0.01312004499419488 * yDotK[0][j].getReal() + -1.2251564463762044 * yDotK[5][j].getReal() + -0.4957589496572502 * yDotK[6][j].getReal() + 1.6643771824549864 * yDotK[7][j].getReal() + -0.35032884874997366 * yDotK[8][j].getReal() + 0.3341791187130175 * yDotK[9][j].getReal() + 0.08192320648511571 * yDotK[10][j].getReal() + -0.022355307863886294 * yDotK[11][j].getReal();
            double errSum2 = -0.18980075407240762 * yDotK[0][j].getReal() + 4.450312892752409 * yDotK[5][j].getReal() + 1.8915178993145003 * yDotK[6][j].getReal() + -5.801203960010585 * yDotK[7][j].getReal() + -0.42268232132379197 * yDotK[8][j].getReal() + -0.1521609496625161 * yDotK[9][j].getReal() + 0.20136540080403034 * yDotK[10][j].getReal() + 0.022651792198360825 * yDotK[11][j].getReal();
            double tol = helper.getTolerance(j, FastMath.max((double)FastMath.abs((double)y0[j].getReal()), (double)FastMath.abs((double)y1[j].getReal())));
            double ratio1 = errSum1 / tol;
            error1 += ratio1 * ratio1;
            double ratio2 = errSum2 / tol;
            error2 += ratio2 * ratio2;
        }
        double den = error1 + 0.01 * error2;
        if (den <= 0.0) {
            den = 1.0;
        }
        return FastMath.abs((double)h.getReal()) * error1 / FastMath.sqrt((double)((double)helper.getMainSetDimension() * den));
    }
}

