/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

enum Transformer {
    UNINITIALIZED{

        @Override
        protected double transformed(double g) {
            return 0.0;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)((CalculusFieldElement)g.getField().getZero());
        }
    }
    ,
    PLUS{

        @Override
        protected double transformed(double g) {
            return g;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return g;
        }
    }
    ,
    MINUS{

        @Override
        protected double transformed(double g) {
            return -g;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)((CalculusFieldElement)g.negate());
        }
    }
    ,
    MIN{

        @Override
        protected double transformed(double g) {
            return FastMath.min((double)FastMath.min((double)(-g), (double)g), (double)(-Precision.SAFE_MIN));
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)FastMath.min((CalculusFieldElement)FastMath.min((CalculusFieldElement)((CalculusFieldElement)g.negate()), g), (double)(-Precision.SAFE_MIN));
        }
    }
    ,
    MAX{

        @Override
        protected double transformed(double g) {
            return FastMath.max((double)FastMath.max((double)(-g), (double)g), (double)Precision.SAFE_MIN);
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)FastMath.max((CalculusFieldElement)FastMath.max((CalculusFieldElement)((CalculusFieldElement)g.negate()), g), (double)Precision.SAFE_MIN);
        }
    };


    protected abstract double transformed(double var1);

    protected abstract <T extends CalculusFieldElement<T>> T transformed(T var1);
}

