/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.hipparchus.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public abstract class MultistepFieldIntegrator<T extends CalculusFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T> {
    protected T[] scaled;
    protected Array2DRowFieldMatrix<T> nordsieck;
    private FieldODEIntegrator<T> starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(field, name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, new Object[]{nSteps, 2, true});
        }
        this.starter = new DormandPrince853FieldIntegrator<T>(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow((double)2.0, (double)(-this.exp)));
    }

    protected MultistepFieldIntegrator(Field<T> field, String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        if (nSteps < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, new Object[]{nSteps, 2, true});
        }
        this.starter = new DormandPrince853FieldIntegrator<T>(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow((double)2.0, (double)(-this.exp)));
    }

    public FieldODEIntegrator<T> getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FieldODEIntegrator<T> starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T t) throws MathIllegalArgumentException, MathIllegalStateException {
        this.starter.clearEventDetectors();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new FieldNordsieckInitializer((this.nSteps + 3) / 2));
        try {
            this.starter.integrate(equations, initialState, t);
            throw new MathIllegalStateException((Localizable)LocalizedODEFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException icme) {
            this.getEvaluationsCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T var1, T[] var2, T[][] var3, T[][] var4);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected void rescale(T newStepSize) {
        CalculusFieldElement ratio = (CalculusFieldElement)newStepSize.divide(this.getStepSize());
        for (int i = 0; i < this.scaled.length; ++i) {
            this.scaled[i] = (CalculusFieldElement)this.scaled[i].multiply((FieldElement)ratio);
        }
        CalculusFieldElement[][] nData = (CalculusFieldElement[][])this.nordsieck.getDataRef();
        CalculusFieldElement power = ratio;
        for (CalculusFieldElement[] nDatum : nData) {
            power = (CalculusFieldElement)power.multiply((FieldElement)ratio);
            CalculusFieldElement[] nDataI = nDatum;
            for (int j = 0; j < nDataI.length; ++j) {
                nDataI[j] = (CalculusFieldElement)nDataI[j].multiply((FieldElement)power);
            }
        }
        this.setStepSize(newStepSize);
    }

    protected double computeStepGrowShrinkFactor(double error) {
        return FastMath.min((double)this.maxGrowth, (double)FastMath.max((double)this.minReduction, (double)(this.safety * FastMath.pow((double)error, (double)this.exp))));
    }

    private class FieldNordsieckInitializer
    implements FieldODEStepHandler<T> {
        private int count = 0;
        private FieldODEStateAndDerivative<T> savedStart;
        private final T[] t;
        private final T[][] y;
        private final T[][] yDot;

        FieldNordsieckInitializer(int nbStartPoints) {
            this.t = (CalculusFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints);
            this.y = (CalculusFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints, (int)-1);
            this.yDot = (CalculusFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)nbStartPoints, (int)-1);
        }

        @Override
        public void handleStep(FieldODEStateInterpolator<T> interpolator) {
            if (this.count == 0) {
                FieldODEStateAndDerivative prev = interpolator.getPreviousState();
                this.savedStart = prev;
                this.t[this.count] = prev.getTime();
                this.y[this.count] = prev.getCompleteState();
                this.yDot[this.count] = prev.getCompleteDerivative();
            }
            ++this.count;
            FieldODEStateAndDerivative curr = interpolator.getCurrentState();
            this.t[this.count] = curr.getTime();
            this.y[this.count] = curr.getCompleteState();
            this.yDot[this.count] = curr.getCompleteDerivative();
            if (this.count == this.t.length - 1) {
                MultistepFieldIntegrator.this.setStepStart(this.savedStart);
                CalculusFieldElement rawStep = (CalculusFieldElement)((CalculusFieldElement)this.t[this.t.length - 1].subtract(this.t[0])).divide((double)(this.t.length - 1));
                MultistepFieldIntegrator.this.setStepSize(MultistepFieldIntegrator.this.getStepSizeHelper().filterStep(rawStep, rawStep.getReal() >= 0.0, true));
                MultistepFieldIntegrator.this.scaled = (CalculusFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), (int)this.yDot[0].length);
                for (int j = 0; j < MultistepFieldIntegrator.this.scaled.length; ++j) {
                    MultistepFieldIntegrator.this.scaled[j] = (CalculusFieldElement)this.yDot[0][j].multiply(MultistepFieldIntegrator.this.getStepSize());
                }
                MultistepFieldIntegrator.this.nordsieck = MultistepFieldIntegrator.this.initializeHighOrderDerivatives((CalculusFieldElement)MultistepFieldIntegrator.this.getStepSize(), (CalculusFieldElement[])this.t, (CalculusFieldElement[][])this.y, (CalculusFieldElement[][])this.yDot);
                throw new InitializationCompletedMarkerException();
            }
        }

        @Override
        public void init(FieldODEStateAndDerivative<T> initialState, T finalTime) {
        }
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }
}

