/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.complex.Complex;
import org.hipparchus.ode.ComplexODEState;
import org.hipparchus.ode.ComplexODEStateAndDerivative;
import org.hipparchus.ode.ComplexOrdinaryDifferentialEquation;
import org.hipparchus.ode.ComplexSecondaryODE;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondaryODE;

public class ComplexODEConverter {
    public OrdinaryDifferentialEquation convertEquations(final ComplexOrdinaryDifferentialEquation equations) {
        return new OrdinaryDifferentialEquation(){

            @Override
            public int getDimension() {
                return 2 * equations.getDimension();
            }

            @Override
            public void init(double t0, double[] y0, double finalTime) {
                equations.init(t0, ComplexODEConverter.this.convert(y0), finalTime);
            }

            @Override
            public double[] computeDerivatives(double t, double[] y) {
                return ComplexODEConverter.this.convert(equations.computeDerivatives(t, ComplexODEConverter.this.convert(y)));
            }
        };
    }

    public SecondaryODE convertSecondaryEquations(final ComplexSecondaryODE equations) {
        return new SecondaryODE(){

            @Override
            public int getDimension() {
                return 2 * equations.getDimension();
            }

            @Override
            public void init(double t0, double[] primary0, double[] secondary0, double finalTime) {
                equations.init(t0, ComplexODEConverter.this.convert(primary0), ComplexODEConverter.this.convert(secondary0), finalTime);
            }

            @Override
            public double[] computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary) {
                return ComplexODEConverter.this.convert(equations.computeDerivatives(t, ComplexODEConverter.this.convert(primary), ComplexODEConverter.this.convert(primaryDot), ComplexODEConverter.this.convert(secondary)));
            }
        };
    }

    public ODEState convertState(ComplexODEState state) {
        double[][] secondary = new double[state.getNumberOfSecondaryStates()][];
        for (int index = 0; index < secondary.length; ++index) {
            secondary[index] = this.convert(state.getSecondaryState(index + 1));
        }
        return new ODEState(state.getTime(), this.convert(state.getPrimaryState()), secondary);
    }

    public ComplexODEStateAndDerivative convertState(ODEStateAndDerivative state) {
        Complex[][] secondary = new Complex[state.getNumberOfSecondaryStates()][];
        Complex[][] secondaryDerivative = new Complex[state.getNumberOfSecondaryStates()][];
        for (int index = 0; index < secondary.length; ++index) {
            secondary[index] = this.convert(state.getSecondaryState(index + 1));
            secondaryDerivative[index] = this.convert(state.getSecondaryDerivative(index + 1));
        }
        return new ComplexODEStateAndDerivative(state.getTime(), this.convert(state.getPrimaryState()), this.convert(state.getPrimaryDerivative()), secondary, secondaryDerivative);
    }

    private Complex[] convert(double[] a) {
        Complex[] converted = new Complex[a.length / 2];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = new Complex(a[2 * i], a[2 * i + 1]);
        }
        return converted;
    }

    private double[] convert(Complex[] a) {
        double[] converted = new double[a.length * 2];
        for (int i = 0; i < a.length; ++i) {
            converted[2 * i] = a[i].getReal();
            converted[2 * i + 1] = a[i].getImaginary();
        }
        return converted;
    }
}

