/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.MathUtils;

public class Edge {
    private final Vertex start;
    private Vertex end;
    private double length;
    private final Circle circle;

    Edge(Vertex start, Vertex end, double length, Circle circle) {
        this.start = start;
        this.end = end;
        this.length = length;
        this.circle = circle;
        start.setOutgoing(this);
        end.setIncoming(this);
    }

    public Vertex getStart() {
        return this.start;
    }

    public Vertex getEnd() {
        return this.end;
    }

    public double getLength() {
        return this.length;
    }

    public Circle getCircle() {
        return this.circle;
    }

    public Vector3D getPointAt(double alpha) {
        return this.circle.getPointAt(alpha + this.circle.getPhase(this.start.getLocation().getVector()));
    }

    void setLength(double length) {
        this.length = length;
    }

    void setNextEdge(Edge next) {
        this.end = next.getStart();
        this.end.setIncoming(this);
    }

    void split(Circle splitCircle, List<Edge> outsideList, List<Edge> insideList) {
        double edgeStart = this.circle.getPhase(this.start.getLocation().getVector());
        Arc arc = this.circle.getInsideArc(splitCircle);
        double arcRelativeStart = MathUtils.normalizeAngle((double)arc.getInf(), (double)(edgeStart + Math.PI)) - edgeStart;
        double arcRelativeEnd = arcRelativeStart + arc.getSize();
        double unwrappedEnd = arcRelativeEnd - Math.PI * 2;
        double tolerance = this.circle.getTolerance();
        Vertex previousVertex = this.start;
        if (unwrappedEnd >= this.length - tolerance) {
            insideList.add(this);
        } else {
            double alreadyManagedLength = 0.0;
            if (unwrappedEnd >= 0.0) {
                previousVertex = this.addSubEdge(previousVertex, new Vertex(new S2Point(this.circle.getPointAt(edgeStart + unwrappedEnd))), unwrappedEnd, insideList);
                alreadyManagedLength = unwrappedEnd;
            }
            if (arcRelativeStart >= this.length - tolerance) {
                if (unwrappedEnd >= 0.0) {
                    this.addSubEdge(previousVertex, this.end, this.length - alreadyManagedLength, outsideList);
                } else {
                    outsideList.add(this);
                }
            } else {
                previousVertex = this.addSubEdge(previousVertex, new Vertex(new S2Point(this.circle.getPointAt(edgeStart + arcRelativeStart))), arcRelativeStart - alreadyManagedLength, outsideList);
                alreadyManagedLength = arcRelativeStart;
                if (arcRelativeEnd >= this.length - tolerance) {
                    this.addSubEdge(previousVertex, this.end, this.length - alreadyManagedLength, insideList);
                } else {
                    previousVertex = this.addSubEdge(previousVertex, new Vertex(new S2Point(this.circle.getPointAt(edgeStart + arcRelativeEnd))), arcRelativeEnd - alreadyManagedLength, insideList);
                    alreadyManagedLength = arcRelativeEnd;
                    this.addSubEdge(previousVertex, this.end, this.length - alreadyManagedLength, outsideList);
                }
            }
        }
    }

    private Vertex addSubEdge(Vertex subStart, Vertex subEnd, double subLength, List<Edge> list) {
        if (subLength <= this.circle.getTolerance()) {
            return subStart;
        }
        Edge edge = new Edge(subStart, subEnd, subLength, this.circle);
        list.add(edge);
        return subEnd;
    }
}

