/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.SubHyperplane;

public class RegionFactory<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
    private final NodesCleaner nodeCleaner = new NodesCleaner();

    @SafeVarargs
    public final Region<S, P, H, I> buildConvex(H ... hyperplanes) {
        if (hyperplanes == null || hyperplanes.length == 0) {
            return null;
        }
        Region region = hyperplanes[0].wholeSpace();
        BSPTree node = region.getTree(false);
        node.setAttribute(Boolean.TRUE);
        for (Object hyperplane : hyperplanes) {
            if (node.insertCut(hyperplane)) {
                node.setAttribute(null);
                node.getPlus().setAttribute(Boolean.FALSE);
                node = node.getMinus();
                node.setAttribute(Boolean.TRUE);
                continue;
            }
            Object s = hyperplane.wholeHyperplane();
            BSPTree tree = node;
            while (tree.getParent() != null && s != null) {
                Object other = tree.getParent().getCut().getHyperplane();
                SubHyperplane.SplitSubHyperplane split = s.split(other);
                switch (split.getSide()) {
                    case HYPER: {
                        if (hyperplane.sameOrientationAs(other)) break;
                        return this.getComplement(hyperplanes[0].wholeSpace());
                    }
                    case PLUS: {
                        throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.NOT_CONVEX_HYPERPLANES, new Object[0]);
                    }
                    default: {
                        s = split.getMinus();
                    }
                }
                tree = tree.getParent();
            }
        }
        return region;
    }

    public Region<S, P, H, I> union(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
        BSPTree<S, P, H, I> tree = region1.getTree(false).merge(region2.getTree(false), new UnionMerger());
        tree.visit(this.nodeCleaner);
        return region1.buildNew(tree);
    }

    public Region<S, P, H, I> intersection(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
        BSPTree<S, P, H, I> tree = region1.getTree(false).merge(region2.getTree(false), new IntersectionMerger(region1, region2));
        tree.visit(this.nodeCleaner);
        return region1.buildNew(tree);
    }

    public Region<S, P, H, I> xor(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
        BSPTree<S, P, H, I> tree = region1.getTree(false).merge(region2.getTree(false), new XorMerger());
        tree.visit(this.nodeCleaner);
        return region1.buildNew(tree);
    }

    public Region<S, P, H, I> difference(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
        BSPTree<S, P, H, I> tree = region1.getTree(false).merge(region2.getTree(false), new DifferenceMerger(region1, region2));
        tree.visit(this.nodeCleaner);
        return region1.buildNew(tree);
    }

    public Region<S, P, H, I> getComplement(Region<S, P, H, I> region) {
        return region.buildNew(this.recurseComplement(region.getTree(false)));
    }

    private BSPTree<S, P, H, I> recurseComplement(BSPTree<S, P, H, I> node) {
        HashMap<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>> map = new HashMap<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>>();
        BSPTree<S, P, H, I> transformedTree = this.recurseComplement(node, map);
        for (Map.Entry entry : map.entrySet()) {
            BoundaryAttribute original;
            if (((BSPTree)entry.getKey()).getCut() == null || (original = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute transformed = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree splitter : original.getSplitters()) {
                transformed.getSplitters().add((BSPTree)map.get(splitter));
            }
        }
        return transformedTree;
    }

    private BSPTree<S, P, H, I> recurseComplement(BSPTree<S, P, H, I> node, Map<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>> map) {
        BSPTree transformedNode;
        if (node.getCut() == null) {
            transformedNode = new BSPTree((Boolean)node.getAttribute() != false ? Boolean.FALSE : Boolean.TRUE);
        } else {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute != null) {
                Object plusOutside = attribute.getPlusInside() == null ? null : (Object)attribute.getPlusInside().copySelf();
                Object plusInside = attribute.getPlusOutside() == null ? null : (Object)attribute.getPlusOutside().copySelf();
                attribute = new BoundaryAttribute(plusOutside, plusInside, new NodesSet());
            }
            transformedNode = new BSPTree(node.getCut().copySelf(), this.recurseComplement(node.getPlus(), map), this.recurseComplement(node.getMinus(), map), attribute);
        }
        map.put(node, transformedNode);
        return transformedNode;
    }

    private class NodesCleaner
    implements BSPTreeVisitor<S, P, H, I> {
        private NodesCleaner() {
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
            return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
        }

        @Override
        public void visitInternalNode(BSPTree<S, P, H, I> node) {
            node.setAttribute(null);
        }

        @Override
        public void visitLeafNode(BSPTree<S, P, H, I> node) {
        }
    }

    private class UnionMerger
    implements BSPTree.LeafMerger<S, P, H, I> {
        private UnionMerger() {
        }

        @Override
        public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> leaf, BSPTree<S, P, H, I> tree, BSPTree<S, P, H, I> parentTree, boolean isPlusChild, boolean leafFromInstance) {
            if (((Boolean)leaf.getAttribute()).booleanValue()) {
                leaf.insertInTree(parentTree, isPlusChild, new VanishingToLeaf(true));
                return leaf;
            }
            tree.insertInTree(parentTree, isPlusChild, new VanishingToLeaf(false));
            return tree;
        }
    }

    private class IntersectionMerger
    extends FixingMerger {
        IntersectionMerger(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
            super(region1, region2);
        }

        @Override
        public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> leaf, BSPTree<S, P, H, I> tree, BSPTree<S, P, H, I> parentTree, boolean isPlusChild, boolean leafFromInstance) {
            if (((Boolean)leaf.getAttribute()).booleanValue()) {
                tree.insertInTree(parentTree, isPlusChild, this);
                return tree;
            }
            leaf.insertInTree(parentTree, isPlusChild, this);
            return leaf;
        }

        @Override
        protected boolean shouldBeInside(Region.Location location1, Region.Location location2) {
            return !location1.equals((Object)Region.Location.OUTSIDE) && !location2.equals((Object)Region.Location.OUTSIDE);
        }
    }

    private class XorMerger
    implements BSPTree.LeafMerger<S, P, H, I> {
        private XorMerger() {
        }

        @Override
        public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> leaf, BSPTree<S, P, H, I> tree, BSPTree<S, P, H, I> parentTree, boolean isPlusChild, boolean leafFromInstance) {
            BSPTree t = tree;
            if (((Boolean)leaf.getAttribute()).booleanValue()) {
                t = RegionFactory.this.recurseComplement(t);
            }
            t.insertInTree(parentTree, isPlusChild, new VanishingToLeaf(true));
            return t;
        }
    }

    private class DifferenceMerger
    extends FixingMerger {
        DifferenceMerger(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
            super(region1, region2);
        }

        @Override
        public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> leaf, BSPTree<S, P, H, I> tree, BSPTree<S, P, H, I> parentTree, boolean isPlusChild, boolean leafFromInstance) {
            if (((Boolean)leaf.getAttribute()).booleanValue()) {
                BSPTree argTree = RegionFactory.this.recurseComplement(leafFromInstance ? tree : leaf);
                argTree.insertInTree(parentTree, isPlusChild, this);
                return argTree;
            }
            BSPTree instanceTree = leafFromInstance ? leaf : tree;
            instanceTree.insertInTree(parentTree, isPlusChild, this);
            return instanceTree;
        }

        @Override
        protected boolean shouldBeInside(Region.Location location1, Region.Location location2) {
            return location1 == Region.Location.INSIDE && location2 == Region.Location.OUTSIDE;
        }
    }

    private class VanishingToLeaf
    implements BSPTree.VanishingCutHandler<S, P, H, I> {
        private final boolean inside;

        VanishingToLeaf(boolean inside) {
            this.inside = inside;
        }

        @Override
        public BSPTree<S, P, H, I> fixNode(BSPTree<S, P, H, I> node) {
            if (node.getPlus().getAttribute().equals(node.getMinus().getAttribute())) {
                return new BSPTree(node.getPlus().getAttribute());
            }
            return new BSPTree(this.inside);
        }
    }

    private abstract class FixingMerger
    implements BSPTree.LeafMerger<S, P, H, I>,
    BSPTree.VanishingCutHandler<S, P, H, I> {
        private final Region<S, P, H, I> region1;
        private final Region<S, P, H, I> region2;

        protected FixingMerger(Region<S, P, H, I> region1, Region<S, P, H, I> region2) {
            this.region1 = region1.copySelf();
            this.region2 = region2.copySelf();
        }

        @Override
        public BSPTree<S, P, H, I> fixNode(BSPTree<S, P, H, I> node) {
            BSPTree.InteriorPoint interior = node.getInteriorPoint(node.getParent().getCut().getHyperplane().arbitraryPoint());
            return new BSPTree(this.shouldBeInside(this.region1.checkPoint(interior.getPoint()), this.region2.checkPoint(interior.getPoint())));
        }

        protected abstract boolean shouldBeInside(Region.Location var1, Region.Location var2);
    }
}

