/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.SubHyperplane;

class Characterization<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
    private I outsideTouching = null;
    private I insideTouching = null;
    private final NodesSet<S, P, H, I> outsideSplitters = new NodesSet();
    private final NodesSet<S, P, H, I> insideSplitters = new NodesSet();

    Characterization(BSPTree<S, P, H, I> node, I sub) {
        this.characterize(node, sub, new ArrayList<BSPTree<S, P, H, I>>());
    }

    private void characterize(BSPTree<S, P, H, I> node, I sub, List<BSPTree<S, P, H, I>> splitters) {
        if (node.getCut() == null) {
            boolean inside = (Boolean)node.getAttribute();
            if (inside) {
                this.addInsideTouching(sub, splitters);
            } else {
                this.addOutsideTouching(sub, splitters);
            }
        } else {
            Object hyperplane = node.getCut().getHyperplane();
            SubHyperplane.SplitSubHyperplane split = sub.split(hyperplane);
            switch (split.getSide()) {
                case PLUS: {
                    this.characterize(node.getPlus(), sub, splitters);
                    break;
                }
                case MINUS: {
                    this.characterize(node.getMinus(), sub, splitters);
                    break;
                }
                case BOTH: {
                    splitters.add(node);
                    this.characterize(node.getPlus(), split.getPlus(), splitters);
                    this.characterize(node.getMinus(), split.getMinus(), splitters);
                    splitters.remove(splitters.size() - 1);
                    break;
                }
                default: {
                    throw MathRuntimeException.createInternalError();
                }
            }
        }
    }

    private void addOutsideTouching(I sub, List<BSPTree<S, P, H, I>> splitters) {
        this.outsideTouching = this.outsideTouching == null ? sub : this.outsideTouching.reunite(sub);
        this.outsideSplitters.addAll(splitters);
    }

    private void addInsideTouching(I sub, List<BSPTree<S, P, H, I>> splitters) {
        this.insideTouching = this.insideTouching == null ? sub : this.insideTouching.reunite(sub);
        this.insideSplitters.addAll(splitters);
    }

    public boolean touchOutside() {
        return this.outsideTouching != null && !this.outsideTouching.isEmpty();
    }

    public I outsideTouching() {
        return this.outsideTouching;
    }

    public NodesSet<S, P, H, I> getOutsideSplitters() {
        return this.outsideSplitters;
    }

    public boolean touchInside() {
        return this.insideTouching != null && !this.insideTouching.isEmpty();
    }

    public I insideTouching() {
        return this.insideTouching;
    }

    public NodesSet<S, P, H, I> getInsideSplitters() {
        return this.insideSplitters;
    }
}

