/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.ArrayList;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Geometry;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Side;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.util.FastMath;

public class BSPTree<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
    private I cut;
    private BSPTree<S, P, H, I> plus;
    private BSPTree<S, P, H, I> minus;
    private BSPTree<S, P, H, I> parent;
    private Object attribute;

    public BSPTree() {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = null;
    }

    public BSPTree(Object attribute) {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = attribute;
    }

    public BSPTree(I cut, BSPTree<S, P, H, I> plus, BSPTree<S, P, H, I> minus, Object attribute) {
        this.cut = cut;
        this.plus = plus;
        this.minus = minus;
        this.parent = null;
        this.attribute = attribute;
        plus.parent = this;
        minus.parent = this;
    }

    public boolean insertCut(H hyperplane) {
        Object chopped;
        if (this.cut != null) {
            this.plus.parent = null;
            this.minus.parent = null;
        }
        if ((chopped = this.fitToCell(hyperplane.wholeHyperplane(), null)) == null || chopped.isEmpty()) {
            this.cut = null;
            this.plus = null;
            this.minus = null;
            return false;
        }
        this.cut = chopped;
        this.plus = new BSPTree<S, P, H, I>();
        this.plus.parent = this;
        this.minus = new BSPTree<S, P, H, I>();
        this.minus.parent = this;
        return true;
    }

    public BSPTree<S, P, H, I> copySelf() {
        if (this.cut == null) {
            return new BSPTree<S, P, H, I>(this.attribute);
        }
        return new BSPTree(this.cut.copySelf(), this.plus.copySelf(), this.minus.copySelf(), this.attribute);
    }

    public I getCut() {
        return this.cut;
    }

    public BSPTree<S, P, H, I> getPlus() {
        return this.plus;
    }

    public BSPTree<S, P, H, I> getMinus() {
        return this.minus;
    }

    public BSPTree<S, P, H, I> getParent() {
        return this.parent;
    }

    public void setAttribute(Object attribute) {
        this.attribute = attribute;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public void visit(BSPTreeVisitor<S, P, H, I> visitor) {
        if (this.cut == null) {
            visitor.visitLeafNode(this);
        } else {
            switch (visitor.visitOrder(this)) {
                case PLUS_MINUS_SUB: {
                    this.plus.visit(visitor);
                    this.minus.visit(visitor);
                    visitor.visitInternalNode(this);
                    break;
                }
                case PLUS_SUB_MINUS: {
                    this.plus.visit(visitor);
                    visitor.visitInternalNode(this);
                    this.minus.visit(visitor);
                    break;
                }
                case MINUS_PLUS_SUB: {
                    this.minus.visit(visitor);
                    this.plus.visit(visitor);
                    visitor.visitInternalNode(this);
                    break;
                }
                case MINUS_SUB_PLUS: {
                    this.minus.visit(visitor);
                    visitor.visitInternalNode(this);
                    this.plus.visit(visitor);
                    break;
                }
                case SUB_PLUS_MINUS: {
                    visitor.visitInternalNode(this);
                    this.plus.visit(visitor);
                    this.minus.visit(visitor);
                    break;
                }
                case SUB_MINUS_PLUS: {
                    visitor.visitInternalNode(this);
                    this.minus.visit(visitor);
                    this.plus.visit(visitor);
                    break;
                }
                default: {
                    throw MathRuntimeException.createInternalError();
                }
            }
        }
    }

    private I fitToCell(I sub, BSPTree<S, P, H, I> ignored) {
        I s = sub;
        BSPTree<S, P, H, I> tree = this;
        while (tree.parent != null && s != null) {
            if (tree.parent != ignored) {
                s = tree == tree.parent.plus ? s.split(tree.parent.cut.getHyperplane()).getPlus() : s.split(tree.parent.cut.getHyperplane()).getMinus();
            }
            tree = tree.parent;
        }
        return s;
    }

    public InteriorPoint<S, P> getInteriorPoint(P defaultPoint) {
        ArrayList edgePoints = new ArrayList();
        for (BSPTree<S, P, H, I> n = this.parent; n != null; n = n.getParent()) {
            Object p;
            Object fit = this.fitToCell(n.getCut().getHyperplane().wholeHyperplane(), n);
            if (fit == null || (p = fit.getInteriorPoint()) == null) continue;
            edgePoints.add(p);
        }
        if (edgePoints.isEmpty()) {
            return new InteriorPoint(defaultPoint, Double.POSITIVE_INFINITY);
        }
        Object barycenter = Geometry.barycenter(edgePoints);
        double min = Double.POSITIVE_INFINITY;
        for (BSPTree<S, P, H, I> n = this.parent; n != null; n = n.getParent()) {
            min = FastMath.min((double)min, (double)FastMath.abs((double)n.getCut().getHyperplane().getOffset(barycenter)));
        }
        return new InteriorPoint(barycenter, min);
    }

    public BSPTree<S, P, H, I> getCell(P point, double tolerance) {
        if (this.cut == null) {
            return this;
        }
        double offset = this.cut.getHyperplane().getOffset(point);
        if (FastMath.abs((double)offset) < tolerance) {
            return this;
        }
        if (offset <= 0.0) {
            return this.minus.getCell(point, tolerance);
        }
        return this.plus.getCell(point, tolerance);
    }

    private void condense() {
        if (this.cut != null && this.plus.cut == null && this.minus.cut == null && (this.plus.attribute == null && this.minus.attribute == null || this.plus.attribute != null && this.plus.attribute.equals(this.minus.attribute))) {
            this.attribute = this.plus.attribute == null ? this.minus.attribute : this.plus.attribute;
            this.cut = null;
            this.plus = null;
            this.minus = null;
        }
    }

    public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> tree, LeafMerger<S, P, H, I> leafMerger) {
        BSPTree<S, P, H, I> merged = this.merge(tree, leafMerger, null, false);
        super.fixCuts();
        return merged;
    }

    private BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> tree, LeafMerger<S, P, H, I> leafMerger, BSPTree<S, P, H, I> parentTree, boolean isPlusChild) {
        if (this.cut == null) {
            return leafMerger.merge(this, tree, parentTree, isPlusChild, true);
        }
        if (tree.cut == null) {
            return leafMerger.merge(tree, this, parentTree, isPlusChild, false);
        }
        BSPTree<S, P, H, I> merged = tree.split(this.cut);
        if (parentTree != null) {
            merged.parent = parentTree;
            if (isPlusChild) {
                parentTree.plus = merged;
            } else {
                parentTree.minus = merged;
            }
        }
        super.merge(merged.plus, leafMerger, merged, true);
        super.merge(merged.minus, leafMerger, merged, false);
        super.condense();
        if (merged.cut != null) {
            merged.cut = super.fitToCell(merged.cut.getHyperplane().wholeHyperplane(), null);
        }
        return merged;
    }

    private void fixCuts() {
        if (this.cut != null) {
            Object fit = this.fitToCell(this.cut.getHyperplane().wholeHyperplane(), null);
            this.cut = fit == null ? this.cut.getHyperplane().emptyHyperplane() : fit;
            super.fixCuts();
            super.fixCuts();
        }
    }

    public BSPTree<S, P, H, I> split(I sub) {
        if (this.cut == null) {
            return new BSPTree<S, P, H, I>(sub, this.copySelf(), new BSPTree<S, P, H, I>(this.attribute), null);
        }
        Object cHyperplane = this.cut.getHyperplane();
        Object sHyperplane = sub.getHyperplane();
        SubHyperplane.SplitSubHyperplane subParts = sub.split(cHyperplane);
        switch (subParts.getSide()) {
            case PLUS: {
                BSPTree<S, P, H, I> split = this.plus.split(sub);
                if (this.cut.split(sHyperplane).getSide() == Side.PLUS) {
                    split.plus = new BSPTree(this.cut.copySelf(), split.plus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    split.plus.parent = split;
                } else {
                    split.minus = new BSPTree(this.cut.copySelf(), split.minus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    split.minus.parent = split;
                }
                return split;
            }
            case MINUS: {
                BSPTree<S, P, H, I> split = this.minus.split(sub);
                if (this.cut.split(sHyperplane).getSide() == Side.PLUS) {
                    split.plus = new BSPTree(this.cut.copySelf(), this.plus.copySelf(), split.plus, this.attribute);
                    super.condense();
                    split.plus.parent = split;
                } else {
                    split.minus = new BSPTree(this.cut.copySelf(), this.plus.copySelf(), split.minus, this.attribute);
                    super.condense();
                    split.minus.parent = split;
                }
                return split;
            }
            case BOTH: {
                SubHyperplane.SplitSubHyperplane cutParts = this.cut.split(sHyperplane);
                BSPTree<S, P, H, I> split = new BSPTree<S, P, H, I>(sub, this.plus.split(subParts.getPlus()), this.minus.split(subParts.getMinus()), null);
                BSPTree<S, P, H, I> tmp = split.plus.minus;
                split.plus.minus = split.minus.plus;
                split.plus.minus.parent = split.plus;
                split.minus.plus = tmp;
                split.minus.plus.parent = split.minus;
                split.plus.cut = cutParts.getPlus() == null ? this.cut.getHyperplane().emptyHyperplane() : cutParts.getPlus();
                split.minus.cut = cutParts.getMinus() == null ? this.cut.getHyperplane().emptyHyperplane() : cutParts.getMinus();
                super.condense();
                super.condense();
                return split;
            }
        }
        return cHyperplane.sameOrientationAs(sHyperplane) ? new BSPTree<S, P, H, I>(sub, this.plus.copySelf(), this.minus.copySelf(), this.attribute) : new BSPTree<S, P, H, I>(sub, this.minus.copySelf(), this.plus.copySelf(), this.attribute);
    }

    public void insertInTree(BSPTree<S, P, H, I> parentTree, boolean isPlusChild, VanishingCutHandler<S, P, H, I> vanishingHandler) {
        this.parent = parentTree;
        if (parentTree != null) {
            if (isPlusChild) {
                parentTree.plus = this;
            } else {
                parentTree.minus = this;
            }
        }
        if (this.cut != null) {
            BSPTree<S, P, H, I> tree = this;
            while (tree.parent != null) {
                Object hyperplane = tree.parent.cut.getHyperplane();
                if (tree == tree.parent.plus) {
                    this.cut = this.cut.split(hyperplane).getPlus();
                    this.fixVanishingCut(vanishingHandler);
                    if (this.cut == null) break;
                    super.chopOffMinus(hyperplane, vanishingHandler);
                    super.chopOffMinus(hyperplane, vanishingHandler);
                } else {
                    this.cut = this.cut.split(hyperplane).getMinus();
                    this.fixVanishingCut(vanishingHandler);
                    if (this.cut == null) break;
                    super.chopOffPlus(hyperplane, vanishingHandler);
                    super.chopOffPlus(hyperplane, vanishingHandler);
                }
                tree = tree.parent;
            }
            this.condense();
        }
    }

    public BSPTree<S, P, H, I> pruneAroundConvexCell(Object cellAttribute, Object otherLeafsAttributes, Object internalAttributes) {
        BSPTree<S, P, H, I> tree = new BSPTree<S, P, H, I>(cellAttribute);
        BSPTree<S, P, H, I> current = this;
        while (current.parent != null) {
            Object parentCut = current.parent.cut.copySelf();
            BSPTree<S, P, H, I> sibling = new BSPTree<S, P, H, I>(otherLeafsAttributes);
            tree = current == current.parent.plus ? new BSPTree(parentCut, tree, sibling, internalAttributes) : new BSPTree(parentCut, sibling, tree, internalAttributes);
            current = current.parent;
        }
        super.fixCuts();
        return tree;
    }

    private void chopOffMinus(H hyperplane, VanishingCutHandler<S, P, H, I> vanishingHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split(hyperplane).getPlus();
            super.chopOffMinus(hyperplane, vanishingHandler);
            super.chopOffMinus(hyperplane, vanishingHandler);
            this.fixVanishingCut(vanishingHandler);
        }
    }

    private void chopOffPlus(H hyperplane, VanishingCutHandler<S, P, H, I> vanishingHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split(hyperplane).getMinus();
            super.chopOffPlus(hyperplane, vanishingHandler);
            super.chopOffPlus(hyperplane, vanishingHandler);
            this.fixVanishingCut(vanishingHandler);
        }
    }

    private void fixVanishingCut(VanishingCutHandler<S, P, H, I> vanishingHandler) {
        if (this.cut == null) {
            BSPTree<S, P, H, I> fixed = vanishingHandler.fixNode(this);
            this.cut = fixed.cut;
            this.plus = fixed.plus;
            this.minus = fixed.minus;
            this.attribute = fixed.attribute;
        }
    }

    public static final class InteriorPoint<S extends Space, P extends Point<S, P>> {
        private final P point;
        private final double distance;

        InteriorPoint(P point, double distance) {
            this.point = point;
            this.distance = distance;
        }

        public P getPoint() {
            return this.point;
        }

        public double getDistance() {
            return this.distance;
        }
    }

    public static interface LeafMerger<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
        public BSPTree<S, P, H, I> merge(BSPTree<S, P, H, I> var1, BSPTree<S, P, H, I> var2, BSPTree<S, P, H, I> var3, boolean var4, boolean var5);
    }

    public static interface VanishingCutHandler<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
        public BSPTree<S, P, H, I> fixNode(BSPTree<S, P, H, I> var1);
    }
}

