/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.oned;

import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.SubOrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.partitioning.Hyperplane;

public class OrientedPoint
implements Hyperplane<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> {
    private final Vector1D location;
    private boolean direct;
    private final double tolerance;

    public OrientedPoint(Vector1D location, boolean direct, double tolerance) {
        this.location = location;
        this.direct = direct;
        this.tolerance = tolerance;
    }

    @Override
    public OrientedPoint copySelf() {
        return this;
    }

    @Override
    public double getOffset(Vector1D point) {
        double delta = point.getX() - this.location.getX();
        return this.direct ? delta : -delta;
    }

    @Override
    public Vector1D moveToOffset(Vector1D point, double offset) {
        return new Vector1D(this.location.getX() + (this.direct ? offset : -offset));
    }

    @Override
    public Vector1D arbitraryPoint() {
        return this.location;
    }

    @Override
    public SubOrientedPoint wholeHyperplane() {
        return new SubOrientedPoint(this, null);
    }

    @Override
    public SubOrientedPoint emptyHyperplane() {
        return new SubOrientedPoint(this, null);
    }

    public IntervalsSet wholeSpace() {
        return new IntervalsSet(this.tolerance);
    }

    @Override
    public boolean sameOrientationAs(OrientedPoint other) {
        return this.direct == other.direct;
    }

    @Override
    public Vector1D project(Vector1D point) {
        return this.location;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public Vector1D getLocation() {
        return this.location;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void revertSelf() {
        this.direct = !this.direct;
    }
}

