/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.jar.impl;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class CodeSource
implements Closeable {
    private static final Log log;
    private static final String JAR_URI_PATH_SEPARATOR = "!/";
    private static final BiFunction<Path, URI, FileSystem> NESTED_JAR_FILESYSTEM_CREATOR;
    private final List<FileSystem> fileSystems = new ArrayList<FileSystem>();
    private final URL codeSourceLocation;
    private FileSystem nonDefaultFileSystem;
    private Path classesPathInFileSystem;

    CodeSource(URL codeSourceLocation) {
        this.codeSourceLocation = codeSourceLocation;
    }

    public InputStream readOrNull(String resourcePathString) throws IOException {
        Exception exception = null;
        try {
            Path rootResourcePath;
            Path relativeResourcePath = this.classesPathOrFail().resolve(resourcePathString);
            if (Files.exists(relativeResourcePath, new LinkOption[0])) {
                return Files.newInputStream(relativeResourcePath, new OpenOption[0]);
            }
            if (this.nonDefaultFileSystem != null && Files.exists(rootResourcePath = this.nonDefaultFileSystem.getRootDirectories().iterator().next().resolve(resourcePathString), new LinkOption[0])) {
                return Files.newInputStream(rootResourcePath, new OpenOption[0]);
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            exception = Throwables.combine(exception, e);
            try {
                URL resourceUrl = new URL(this.codeSourceLocation, resourcePathString);
                return resourceUrl.openStream();
            }
            catch (FileNotFoundException e2) {
                return null;
            }
            catch (IOException | RuntimeException e3) {
                exception = Throwables.combine(exception, e3);
                throw new IOException("Could not open '" + resourcePathString + "' within '" + this.codeSourceLocation + "': " + exception.getMessage(), exception);
            }
        }
    }

    public Path classesPathOrFail() throws IOException {
        this.initFileSystem();
        return this.classesPathInFileSystem;
    }

    void initFileSystem() throws IOException {
        block7: {
            if (this.classesPathInFileSystem != null) {
                return;
            }
            try {
                if ("jar".equals(this.codeSourceLocation.getProtocol())) {
                    this.tryInitJarFileSystem(this.codeSourceLocation.toURI());
                    break block7;
                }
                if ("file".equals(this.codeSourceLocation.getProtocol())) {
                    Path path = Paths.get(this.codeSourceLocation.toURI());
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.nonDefaultFileSystem = null;
                        this.classesPathInFileSystem = path;
                    } else {
                        URI jarUri = new URI("jar:file", null, path.toString(), null);
                        this.tryInitJarFileSystem(jarUri);
                    }
                    break block7;
                }
                throw log.cannotInterpretCodeSourceUrl(this.codeSourceLocation);
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw log.cannotOpenCodeSourceFileSystem(this.codeSourceLocation, e.getMessage(), e);
            }
        }
    }

    private void tryInitJarFileSystem(URI jarUri) throws IOException {
        try {
            this.changeFileSystemAndMarkPreviousOneForClosing(FileSystems.newFileSystem(jarUri, Collections.emptyMap()));
            this.classesPathInFileSystem = this.nonDefaultFileSystem.getRootDirectories().iterator().next();
            Path nestedPath = this.extractedJarNestedPath(jarUri);
            if (nestedPath != null && !Files.isRegularFile(nestedPath, new LinkOption[0])) {
                this.classesPathInFileSystem = nestedPath;
            }
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser(e).push(this.nonDefaultFileSystem);
            this.nonDefaultFileSystem = null;
            this.classesPathInFileSystem = null;
            throw e;
        }
    }

    private Path extractedJarNestedPath(URI jarUri) {
        String spec = jarUri.getSchemeSpecificPart();
        if (spec == null) {
            return null;
        }
        int pathSeparatorIndex = spec.indexOf(JAR_URI_PATH_SEPARATOR);
        if (pathSeparatorIndex < 0) {
            return null;
        }
        int afterPathSeparatorIndex = pathSeparatorIndex + JAR_URI_PATH_SEPARATOR.length();
        int secondPathSeparatorIndex = spec.indexOf(JAR_URI_PATH_SEPARATOR, afterPathSeparatorIndex);
        while (0 <= secondPathSeparatorIndex) {
            Path nestedPathInFileSystem = this.classesPathInFileSystem.resolve(spec.substring(afterPathSeparatorIndex, secondPathSeparatorIndex));
            if (!Files.isRegularFile(nestedPathInFileSystem, new LinkOption[0])) {
                return nestedPathInFileSystem;
            }
            this.changeFileSystemAndMarkPreviousOneForClosing(NESTED_JAR_FILESYSTEM_CREATOR.apply(nestedPathInFileSystem, jarUri));
            this.classesPathInFileSystem = this.nonDefaultFileSystem.getRootDirectories().iterator().next();
            afterPathSeparatorIndex = secondPathSeparatorIndex;
            secondPathSeparatorIndex = spec.indexOf(JAR_URI_PATH_SEPARATOR, afterPathSeparatorIndex);
        }
        return this.classesPathInFileSystem.resolve(spec.substring(afterPathSeparatorIndex, secondPathSeparatorIndex));
    }

    private void changeFileSystemAndMarkPreviousOneForClosing(FileSystem fileSystem) {
        if (this.nonDefaultFileSystem != null) {
            this.fileSystems.add(0, this.nonDefaultFileSystem);
        }
        this.nonDefaultFileSystem = fileSystem;
    }

    @Override
    public void close() throws IOException {
        if (this.nonDefaultFileSystem != null) {
            this.changeFileSystemAndMarkPreviousOneForClosing(null);
        }
        try (Closer closer = new Closer();){
            closer.pushAll(FileSystem::close, this.fileSystems);
        }
    }

    static {
        BiFunction<Path, URI, FileSystem> creator;
        log = LoggerFactory.make(Log.class, MethodHandles.lookup());
        try {
            Method newFileSystem = FileSystems.class.getMethod("newFileSystem", Path.class, Map.class);
            creator = (path, jarUri) -> {
                try {
                    return (FileSystem)newFileSystem.invoke(null, path, Collections.emptyMap());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw log.cannotOpenNestedJar((URI)jarUri, e);
                }
            };
        }
        catch (NoSuchMethodException ignored) {
            creator = (path, jarUri) -> {
                throw log.cannotOpenNestedJar((URI)jarUri, null);
            };
        }
        NESTED_JAR_FILESYSTEM_CREATOR = creator;
    }
}

