/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptedWorkError(Runnable r) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedWorkError$str(), (Object)r);
    }

    protected String interruptedWorkError$str() {
        return "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    }

    @Override
    public final void exceptionOccurred(String errorMsg, Throwable exceptionThatOccurred) {
        this.log.logf(FQCN, Logger.Level.ERROR, exceptionThatOccurred, this.exceptionOccurred$str(), (Object)errorMsg);
    }

    protected String exceptionOccurred$str() {
        return "HSEARCH000058: %1$s";
    }

    protected String mustNotBeNull$str() {
        return "HSEARCH900000: '%1$s' must not be null.";
    }

    @Override
    public final IllegalArgumentException mustNotBeNull(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustNotBeNull$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String collectionMustNotBeNullNorEmpty$str() {
        return "HSEARCH900001: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException collectionMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.collectionMustNotBeNullNorEmpty$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBePositiveOrZero$str() {
        return "HSEARCH900002: '%1$s' must be positive or zero.";
    }

    @Override
    public final IllegalArgumentException mustBePositiveOrZero(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBePositiveOrZero$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stringMustNotBeNullNorEmpty$str() {
        return "HSEARCH900003: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException stringMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.stringMustNotBeNullNorEmpty$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String arrayMustNotBeNullNorEmpty$str() {
        return "HSEARCH900004: '%1$s' must not be null or empty.";
    }

    @Override
    public final IllegalArgumentException arrayMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.arrayMustNotBeNullNorEmpty$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorInvokingMember$str() {
        return "HSEARCH900005: Exception while invoking '%1$s' on '%2$s'.";
    }

    @Override
    public final SearchException errorInvokingMember(Member member, String componentAsString, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorInvokingMember$str(), member, componentAsString), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRequestTypeParameterOfUnparameterizedType$str() {
        return "HSEARCH900006: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter";
    }

    @Override
    public final IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRequestTypeParameterOfUnparameterizedType$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typeParameterIndexOutOfBound$str() {
        return "HSEARCH900007: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s)";
    }

    @Override
    public final IllegalArgumentException typeParameterIndexOutOfBound(Type type, Class<?> rawSuperType, int typeArgumentIndex, int typeParametersLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.typeParameterIndexOutOfBound$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex, typeParametersLength));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeParameterIndex$str() {
        return "HSEARCH900008: Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater";
    }

    @Override
    public final IllegalArgumentException invalidTypeParameterIndex(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTypeParameterIndex$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotAccessRepeateableContainingAnnotationValue(Class<?> containingAnnotationType, Throwable e) {
        this.log.logf(FQCN, Logger.Level.INFO, e, this.cannotAccessRepeateableContainingAnnotationValue$str(), (Object)new ClassFormatter(containingAnnotationType));
    }

    protected String cannotAccessRepeateableContainingAnnotationValue$str() {
        return "HSEARCH900009: Cannot access the value of containing annotation '%1$s'. Ignoring annotation.";
    }

    protected String mustBeStrictlyPositive$str() {
        return "HSEARCH900010: '%1$s' must be strictly positive.";
    }

    @Override
    public final IllegalArgumentException mustBeStrictlyPositive(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBeStrictlyPositive$str(), objectDescription));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

