/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmMapperSpiSettings;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmReflectionStrategyName;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmGenericContextHelper;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.reflect.spi.AnnotationHelper;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

public class HibernateOrmBootstrapIntrospector
extends AbstractPojoHCAnnBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final ConfigurationProperty<HibernateOrmReflectionStrategyName> REFLECTION_STRATEGY = ConfigurationProperty.forKey((String)"reflection.strategy").as(HibernateOrmReflectionStrategyName.class, HibernateOrmReflectionStrategyName::of).withDefault((Object)HibernateOrmMapperSpiSettings.Defaults.REFLECTION_STRATEGY).build();
    private final Map<Class<?>, HibernateOrmBasicTypeMetadata> typeMetadata;
    private final ValueReadHandleFactory valueReadHandleFactory;
    private final HibernateOrmGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, PojoRawTypeModel<?>> typeModelCache = new HashMap();

    public static HibernateOrmBootstrapIntrospector create(Metadata metadata, ReflectionManager ormReflectionManager, ConfigurationPropertySource propertySource) {
        ValueReadHandleFactory valueReadHandleFactory;
        Collection persistentClasses = metadata.getEntityBindings().stream().filter(PersistentClass::hasPojoRepresentation).collect(Collectors.toList());
        HashMap typeMetadata = new HashMap();
        HibernateOrmBootstrapIntrospector.collectPersistentTypes(typeMetadata, persistentClasses);
        for (PersistentClass persistentClass : persistentClasses) {
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(typeMetadata, (Value)persistentClass.getIdentifier());
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(typeMetadata, persistentClass.getPropertyIterator());
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        HibernateOrmReflectionStrategyName reflectionStrategyName = (HibernateOrmReflectionStrategyName)((Object)REFLECTION_STRATEGY.get(propertySource));
        switch (reflectionStrategyName) {
            case JAVA_LANG_REFLECT: {
                valueReadHandleFactory = ValueReadHandleFactory.usingJavaLangReflect();
                break;
            }
            case METHOD_HANDLE: {
                valueReadHandleFactory = ValueReadHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected reflection strategy name: " + (Object)((Object)reflectionStrategyName));
            }
        }
        return new HibernateOrmBootstrapIntrospector(typeMetadata, ormReflectionManager, valueReadHandleFactory);
    }

    private static void collectPersistentTypes(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Collection<PersistentClass> persistentClasses) {
        for (PersistentClass persistentClass : persistentClasses) {
            collected.put(persistentClass.getMappedClass(), HibernateOrmBasicTypeMetadata.create(persistentClass));
        }
    }

    private static void collectEmbeddedTypesRecursively(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Iterator<Property> propertyIterator) {
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, property.getValue());
        }
    }

    private static void collectEmbeddedTypesRecursively(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Value value) {
        if (value instanceof Component) {
            Component component = (Component)value;
            collected.computeIfAbsent(component.getComponentClass(), ignored -> HibernateOrmBasicTypeMetadata.create(component));
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, component.getPropertyIterator());
        } else if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, collection.getElement());
            if (collection instanceof IndexedCollection) {
                IndexedCollection indexedCollection = (IndexedCollection)collection;
                HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, indexedCollection.getIndex());
            }
        }
    }

    private HibernateOrmBootstrapIntrospector(Map<Class<?>, HibernateOrmBasicTypeMetadata> typeMetadata, ReflectionManager reflectionManager, ValueReadHandleFactory valueReadHandleFactory) {
        super(reflectionManager, new AnnotationHelper(valueReadHandleFactory));
        this.typeMetadata = typeMetadata;
        this.valueReadHandleFactory = valueReadHandleFactory;
        this.genericContextHelper = new HibernateOrmGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public <T> HibernateOrmRawTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return (HibernateOrmRawTypeModel)this.typeModelCache.computeIfAbsent(clazz, this::createTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getAscendingSuperTypes(XClass xClass) {
        return this.getAscendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getDescendingSuperTypes(XClass xClass) {
        return this.getDescendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    ValueReadHandle<?> createValueReadHandle(Member member, HibernateOrmBasicPropertyMetadata ormPropertyMetadata) throws IllegalAccessException {
        if (member instanceof Method) {
            Method method = (Method)member;
            HibernateOrmBootstrapIntrospector.setAccessible(method);
            return this.valueReadHandleFactory.createForMethod(method);
        }
        if (member instanceof Field) {
            Method bytecodeEnhancerReaderMethod;
            Field field = (Field)member;
            if (ormPropertyMetadata != null && !ormPropertyMetadata.isId() && (bytecodeEnhancerReaderMethod = HibernateOrmBootstrapIntrospector.getBytecodeEnhancerReaderMethod(field)) != null) {
                HibernateOrmBootstrapIntrospector.setAccessible(bytecodeEnhancerReaderMethod);
                return this.valueReadHandleFactory.createForMethod(bytecodeEnhancerReaderMethod);
            }
            HibernateOrmBootstrapIntrospector.setAccessible(field);
            return this.valueReadHandleFactory.createForField(field);
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + member);
    }

    private <T> PojoRawTypeModel<T> createTypeModel(Class<T> type) {
        return new HibernateOrmRawTypeModel<T>(this, type, this.typeMetadata.get(type), new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, type));
    }

    private static void setAccessible(AccessibleObject member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(((Member)((Object)member)).getModifiers())) break block2;
                throw se;
            }
        }
    }

    private static Method getBytecodeEnhancerReaderMethod(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        if (!PersistentAttributeInterceptable.class.isAssignableFrom(declaringClass)) {
            return null;
        }
        try {
            return declaringClass.getDeclaredMethod("$$_hibernate_read_" + field.getName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Read method for enhanced field " + field + " is unexpectedly missing.", (Throwable)e);
        }
    }
}

