/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.util.Objects;
import org.hibernate.search.mapper.orm.common.EntityReference;

public class EntityReferenceImpl
implements EntityReference {
    private final Class<?> type;
    private final String name;
    private final Object id;

    public static EntityReference withDefaultName(Class<?> type, Object id) {
        return new EntityReferenceImpl(type, type.getSimpleName(), id);
    }

    public EntityReferenceImpl(Class<?> type, String name, Object id) {
        this.type = type;
        this.name = name;
        this.id = id;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EntityReferenceImpl other = (EntityReferenceImpl)obj;
        return this.name.equals(other.name) && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public String toString() {
        return this.name + "#" + this.id;
    }
}

