/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.ClassBridgeMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class EntitySpatialMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final Map<String, Object> spatial = new HashMap<String, Object>();

    public EntitySpatialMapping(SearchMapping mapping, EntityDescriptor entity) {
        this.mapping = mapping;
        this.entity = entity;
        this.entity.addSpatial(this.spatial);
    }

    public EntitySpatialMapping spatial() {
        return new EntitySpatialMapping(this.mapping, this.entity);
    }

    public EntitySpatialMapping name(String fieldName) {
        this.spatial.put("name", fieldName);
        return this;
    }

    public EntitySpatialMapping store(Store store) {
        this.spatial.put("store", (Object)store);
        return this;
    }

    public EntitySpatialMapping boost(float boost) {
        HashMap<String, Float> boostAnn = new HashMap<String, Float>();
        boostAnn.put("value", Float.valueOf(boost));
        this.spatial.put("boost", boostAnn);
        return this;
    }

    public EntitySpatialMapping spatialMode(SpatialMode spatialMode) {
        this.spatial.put("spatialMode", (Object)spatialMode);
        return this;
    }

    public EntitySpatialMapping topSpatialHashLevel(int topSpatialHashLevel) {
        this.spatial.put("topSpatialHashLevel", topSpatialHashLevel);
        return this;
    }

    public EntitySpatialMapping bottomSpatialHashLevel(int bottomSpatialHashLevel) {
        this.spatial.put("bottomSpatialHashLevel", bottomSpatialHashLevel);
        return this;
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public ClassBridgeMapping classBridge(Class<?> impl) {
        return new ClassBridgeMapping(this.mapping, this.entity, impl);
    }

    public ClassBridgeMapping classBridgeInstance(FieldBridge instance) {
        return new ClassBridgeMapping(this.mapping, this.entity, instance);
    }
}

