/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import org.hibernate.search.bridge.ContainerBridge;
import org.hibernate.search.bridge.util.impl.BridgeAdaptor;

public final class BridgeAdaptorUtils {
    private BridgeAdaptorUtils() {
    }

    public static <T> T unwrapAdaptorAndContainer(Object bridge, Class<T> clazz) {
        T resultFromAdaptor = BridgeAdaptorUtils.unwrapAdaptorOnly(bridge, clazz);
        if (resultFromAdaptor != null) {
            return resultFromAdaptor;
        }
        Object elementBridge = BridgeAdaptorUtils.getElementBridge(bridge);
        if (elementBridge != null) {
            return BridgeAdaptorUtils.unwrapAdaptorAndContainer(elementBridge, clazz);
        }
        return null;
    }

    private static Object getElementBridge(Object bridge) {
        ContainerBridge containerBridge = null;
        if (bridge instanceof BridgeAdaptor) {
            containerBridge = ((BridgeAdaptor)bridge).unwrap(ContainerBridge.class);
        } else if (bridge instanceof ContainerBridge) {
            containerBridge = (ContainerBridge)bridge;
        }
        return containerBridge == null ? null : containerBridge.getElementBridge();
    }

    public static <T> T unwrapAdaptorOnly(Object bridge, Class<T> clazz) {
        if (clazz.isInstance(bridge)) {
            return clazz.cast(bridge);
        }
        if (bridge instanceof BridgeAdaptor) {
            return ((BridgeAdaptor)bridge).unwrap(clazz);
        }
        return null;
    }
}

