/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.Term;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DeleteExtWorkExecutor
extends DeleteWorkExecutor {
    private final Class<?> managedType;
    private final DocumentBuilderIndexedEntity builder;
    private static final Log log = LoggerFactory.make();
    private final boolean idIsNumeric;

    DeleteExtWorkExecutor(Workspace workspace) {
        super(workspace);
        this.managedType = workspace.getEntitiesInIndexManager().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
        this.idIsNumeric = DeleteExtWorkExecutor.isIdNumeric(this.builder);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        this.checkType(work);
        Serializable id = work.getId();
        log.tracef("Removing %s#%s by id using an IndexWriter.", this.managedType, id);
        try {
            if (this.idIsNumeric) {
                delegate.deleteDocuments(NumericFieldUtils.createExactMatchQuery(this.builder.getIdFieldName(), id));
            } else {
                Term idTerm = new Term(this.builder.getIdFieldName(), work.getIdInString());
                delegate.deleteDocuments(idTerm);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to remove " + this.managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type");
        }
    }
}

