/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaModelGenerationException;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.StringUtil;

public final class TypeUtils {
    public static final String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final Map<TypeKind, String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();
    private static final Map<TypeKind, String> PRIMITIVES = new HashMap<TypeKind, String>();

    private TypeUtils() {
    }

    public static String toTypeString(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return PRIMITIVE_WRAPPERS.get((Object)type.getKind());
        }
        return type.toString();
    }

    public static String toArrayTypeString(ArrayType type, Context context) {
        TypeMirror componentType = type.getComponentType();
        if (componentType.getKind().isPrimitive()) {
            return PRIMITIVES.get((Object)componentType.getKind()) + "[]";
        }
        TypeMirror component = componentType.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return e;
            }
        }, null);
        return TypeUtils.extractClosestRealTypeAsString(component, context) + "[]";
    }

    public static TypeElement getSuperclassTypeElement(TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    public static String extractClosestRealTypeAsString(TypeMirror type, Context context) {
        if (type instanceof TypeVariable) {
            TypeMirror compositeUpperBound = ((TypeVariable)type).getUpperBound();
            return TypeUtils.extractClosestRealTypeAsString(compositeUpperBound, context);
        }
        TypeMirror erasureType = context.getTypeUtils().erasure(type);
        if (TypeKind.ARRAY.equals((Object)erasureType.getKind())) {
            return erasureType.toString();
        }
        return ((TypeElement)context.getTypeUtils().asElement(erasureType)).getQualifiedName().toString();
    }

    public static boolean containsAnnotation(Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        ArrayList annotationClassNames = new ArrayList();
        Collections.addAll(annotationClassNames, annotations);
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationMirrorOfType(AnnotationMirror annotationMirror, String fqcn) {
        assert (annotationMirror != null);
        assert (fqcn != null);
        String annotationClassName = annotationMirror.getAnnotationType().toString();
        return annotationClassName.equals(fqcn);
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String fqcn) {
        assert (element != null);
        assert (fqcn != null);
        AnnotationMirror mirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, fqcn)) continue;
            mirror = annotationMirror;
            break;
        }
        return mirror;
    }

    public static Object getAnnotationValue(AnnotationMirror annotationMirror, String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        Object returnValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!parameterValue.equals(entry.getKey().getSimpleName().toString())) continue;
            returnValue = entry.getValue().getValue();
            break;
        }
        return returnValue;
    }

    public static void determineAccessTypeForHierarchy(TypeElement searchedElement, Context context) {
        String fqcn = searchedElement.getQualifiedName().toString();
        context.logMessage(Diagnostic.Kind.OTHER, "Determining access type for " + fqcn);
        AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(fqcn);
        if (accessTypeInfo != null && accessTypeInfo.isAccessTypeResolved()) {
            context.logMessage(Diagnostic.Kind.OTHER, "AccessType for " + searchedElement.toString() + " found in cache: " + accessTypeInfo);
            return;
        }
        AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(searchedElement);
        if (forcedAccessType != null) {
            context.logMessage(Diagnostic.Kind.OTHER, "Explicit access type on " + searchedElement + ":" + (Object)((Object)forcedAccessType));
            accessTypeInfo = new AccessTypeInformation(fqcn, forcedAccessType, null);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
            TypeUtils.updateEmbeddableAccessType(searchedElement, context, forcedAccessType);
            return;
        }
        AccessType defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(searchedElement, context);
        if (defaultAccessType != null) {
            accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
            TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
            TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(searchedElement, defaultAccessType, context);
            return;
        }
        defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(searchedElement, context);
        if (defaultAccessType == null) {
            defaultAccessType = AccessType.PROPERTY;
        }
        accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
        context.addAccessTypeInformation(fqcn, accessTypeInfo);
        TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
    }

    public static TypeMirror getCollectionElementType(DeclaredType t, String fqNameOfReturnedType, String explicitTargetEntityName, Context context) {
        TypeMirror collectionElementType;
        if (explicitTargetEntityName != null) {
            Elements elements = context.getElementUtils();
            TypeElement element = elements.getTypeElement(explicitTargetEntityName);
            collectionElementType = element.asType();
        } else {
            List<? extends TypeMirror> typeArguments = t.getTypeArguments();
            if (typeArguments.size() == 0) {
                throw new MetaModelGenerationException("Unable to determine collection type");
            }
            collectionElementType = Map.class.getCanonicalName().equals(fqNameOfReturnedType) ? t.getTypeArguments().get(1) : t.getTypeArguments().get(0);
        }
        return collectionElementType;
    }

    private static void updateEmbeddableAccessType(TypeElement element, Context context, AccessType defaultAccessType) {
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (Element element2 : fieldsOfClass) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element2);
        }
        List<ExecutableElement> methodOfClass = ElementFilter.methodsIn(element.getEnclosedElements());
        for (Element element3 : methodOfClass) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element3);
        }
    }

    private static void updateEmbeddableAccessTypeForMember(Context context, AccessType defaultAccessType, Element member) {
        EmbeddedAttributeVisitor visitor = new EmbeddedAttributeVisitor(context);
        String embeddedClassName = member.asType().accept(visitor, member);
        if (embeddedClassName != null) {
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(embeddedClassName);
            if (accessTypeInfo == null) {
                accessTypeInfo = new AccessTypeInformation(embeddedClassName, null, defaultAccessType);
                context.addAccessTypeInformation(embeddedClassName, accessTypeInfo);
            } else {
                accessTypeInfo.setDefaultAccessType(defaultAccessType);
            }
        }
    }

    private static AccessType getDefaultAccessForHierarchy(TypeElement element, Context context) {
        AccessType defaultAccessType = null;
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String fqcn = superClass.getQualifiedName().toString();
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(fqcn);
            if (accessTypeInfo != null && accessTypeInfo.getDefaultAccessType() != null) {
                return accessTypeInfo.getDefaultAccessType();
            }
            if (!TypeUtils.containsAnnotation(superClass, "javax.persistence.Entity", "javax.persistence.MappedSuperclass")) continue;
            defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(superClass, context);
            if (defaultAccessType != null) {
                accessTypeInfo = new AccessTypeInformation(fqcn, null, defaultAccessType);
                context.addAccessTypeInformation(fqcn, accessTypeInfo);
                TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(superClass, defaultAccessType, context);
                break;
            }
            defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(superClass, context);
        } while (superClass != null);
        return defaultAccessType;
    }

    private static void setDefaultAccessTypeForMappedSuperclassesInHierarchy(TypeElement element, AccessType defaultAccessType, Context context) {
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String fqcn = superClass.getQualifiedName().toString();
            if (!TypeUtils.containsAnnotation(superClass, "javax.persistence.MappedSuperclass")) continue;
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(superClass);
            AccessTypeInformation accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(fqcn, null, forcedAccessType) : new AccessTypeInformation(fqcn, null, defaultAccessType);
            context.addAccessTypeInformation(fqcn, accessTypeInfo);
        } while (superClass != null);
    }

    private static AccessType getAccessTypeInCaseElementIsRoot(TypeElement searchedElement, Context context) {
        List<? extends Element> myMembers = searchedElement.getEnclosedElements();
        for (Element element : myMembers) {
            List<? extends AnnotationMirror> entityAnnotations = context.getElementUtils().getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : entityAnnotations) {
                AnnotationMirror annotationMirror2 = annotationMirror;
                if (!TypeUtils.isIdAnnotation(annotationMirror2)) continue;
                return TypeUtils.getAccessTypeOfIdAnnotation(element);
            }
        }
        return null;
    }

    private static AccessType getAccessTypeOfIdAnnotation(Element element) {
        AccessType accessType = null;
        ElementKind kind = element.getKind();
        if (kind == ElementKind.FIELD || kind == ElementKind.METHOD) {
            accessType = kind == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
        }
        return accessType;
    }

    private static boolean isIdAnnotation(AnnotationMirror annotationMirror) {
        return TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.Id") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.EmbeddedId");
    }

    public static AccessType determineAnnotationSpecifiedAccessType(Element element) {
        Element accessElement;
        AnnotationMirror accessAnnotationMirror = TypeUtils.getAnnotationMirror(element, "javax.persistence.Access");
        AccessType forcedAccessType = null;
        if (accessAnnotationMirror != null && (accessElement = (Element)TypeUtils.getAnnotationValue(accessAnnotationMirror, DEFAULT_ANNOTATION_PARAMETER_NAME)).getKind().equals((Object)ElementKind.ENUM_CONSTANT)) {
            if (accessElement.getSimpleName().toString().equals(AccessType.PROPERTY.toString())) {
                forcedAccessType = AccessType.PROPERTY;
            } else if (accessElement.getSimpleName().toString().equals(AccessType.FIELD.toString())) {
                forcedAccessType = AccessType.FIELD;
            }
        }
        return forcedAccessType;
    }

    public static ElementKind getElementKindForAccessType(AccessType accessType) {
        if (AccessType.FIELD.equals((Object)accessType)) {
            return ElementKind.FIELD;
        }
        return ElementKind.METHOD;
    }

    public static String getKeyType(DeclaredType t, Context context) {
        List<? extends TypeMirror> typeArguments = t.getTypeArguments();
        if (typeArguments.size() == 0) {
            context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type argument for " + t);
        }
        return TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), context);
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "Double");
        PRIMITIVES.put(TypeKind.CHAR, "char");
        PRIMITIVES.put(TypeKind.BYTE, "byte");
        PRIMITIVES.put(TypeKind.SHORT, "short");
        PRIMITIVES.put(TypeKind.INT, "int");
        PRIMITIVES.put(TypeKind.LONG, "long");
        PRIMITIVES.put(TypeKind.BOOLEAN, "boolean");
        PRIMITIVES.put(TypeKind.FLOAT, "float");
        PRIMITIVES.put(TypeKind.DOUBLE, "double");
    }

    static class EmbeddedAttributeVisitor
    extends SimpleTypeVisitor6<String, Element> {
        private Context context;

        EmbeddedAttributeVisitor(Context context) {
            this.context = context;
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = null;
            if (TypeUtils.containsAnnotation(returnedElement, "javax.persistence.Embeddable")) {
                fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            }
            return fqNameOfReturnType;
        }

        @Override
        public String visitExecutable(ExecutableType t, Element p) {
            if (!p.getKind().equals((Object)ElementKind.METHOD)) {
                return null;
            }
            String string = p.getSimpleName().toString();
            if (!StringUtil.isProperty(string, TypeUtils.toTypeString(t.getReturnType()))) {
                return null;
            }
            TypeMirror returnType = t.getReturnType();
            return returnType.accept(this, p);
        }
    }
}

