/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal;

import java.util.List;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.graph.spi.GraphNodeImplementor;
import org.hibernate.jpa.graph.internal.AbstractGraphNode;
import org.hibernate.jpa.graph.internal.SubgraphImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;

public class EntityGraphImpl<T>
extends AbstractGraphNode<T>
implements EntityGraph<T>,
GraphNodeImplementor {
    private final String name;
    private final EntityType<T> entityType;

    public EntityGraphImpl(String name, EntityType<T> entityType, EntityManagerFactoryImpl entityManagerFactory) {
        super(entityManagerFactory, true);
        this.name = name;
        this.entityType = entityType;
    }

    public EntityGraphImpl<T> makeImmutableCopy(String name) {
        return new EntityGraphImpl<T>(name, this, false);
    }

    public EntityGraphImpl<T> makeMutableCopy() {
        return new EntityGraphImpl<T>(this.name, this, true);
    }

    private EntityGraphImpl(String name, EntityGraphImpl<T> original, boolean mutable) {
        super(original, mutable);
        this.name = name;
        this.entityType = original.entityType;
    }

    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addAttributeNodes(String ... attributeNames) {
        super.addAttributeNodes(attributeNames);
    }

    @Override
    public void addAttributeNodes(Attribute<T, ?> ... attributes) {
        super.addAttributeNodes(attributes);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(Attribute<T, X> attribute) {
        return super.addSubgraph(attribute);
    }

    @Override
    public <X> SubgraphImpl<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addSubgraph(attribute, type);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(String attributeName) {
        return super.addSubgraph(attributeName);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(String attributeName, Class<X> type) {
        return super.addSubgraph(attributeName, type);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(Attribute<T, X> attribute) {
        return super.addKeySubgraph(attribute);
    }

    @Override
    public <X> SubgraphImpl<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addKeySubgraph(attribute, type);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(String attributeName) {
        return super.addKeySubgraph(attributeName);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(String attributeName, Class<X> type) {
        return super.addKeySubgraph(attributeName, type);
    }

    public <T1> Subgraph<? extends T1> addSubclassSubgraph(Class<? extends T1> type) {
        throw new NotYetImplementedException();
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        return super.attributeNodes();
    }

    @Override
    protected Attribute<T, ?> resolveAttribute(String attributeName) {
        Attribute attribute = this.entityType.getAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Given attribute name [%s] is not an attribute on this entity [%s]", attributeName, this.entityType.getName()));
        }
        return attribute;
    }

    public boolean appliesTo(String entityName) {
        return this.appliesTo(this.getFactory().getEntityTypeByName(entityName));
    }

    public boolean appliesTo(EntityType<? super T> entityType) {
        if (this.entityType.equals(entityType)) {
            return true;
        }
        for (IdentifiableType superType = entityType.getSupertype(); superType != null; superType = superType.getSupertype()) {
            if (!superType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    @Override
    ManagedType getManagedType() {
        return this.entityType;
    }
}

