/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.persistence.Enumerated;
import javax.persistence.MapKeyEnumerated;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.jboss.logging.Logger;

public class EnumType
implements EnhancedUserType,
DynamicParameterizedType,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EnumType.class.getName());
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    private Class<? extends Enum> enumClass;
    private transient Object[] enumValues;
    private int sqlType = 4;

    @Override
    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    @Override
    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Returning null as column {0}", names[0]);
            }
            return null;
        }
        if (object instanceof Number) {
            this.initEnumValues();
            int ordinal = ((Number)object).intValue();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Returning '{0}' as column {1}", ordinal, names[0]);
            }
            return this.enumValues[ordinal];
        }
        String name = (String)object;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Returning '{0}' as column {1}", name, names[0]);
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Binding null to parameter: {0}", index);
            }
            st.setNull(index, this.sqlType);
        } else {
            boolean isOrdinal = this.isOrdinal(this.sqlType);
            if (isOrdinal) {
                int ordinal = ((Enum)value).ordinal();
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Binding '{0}' to parameter: '{1}", ordinal, index);
                }
                st.setObject(index, (Object)ordinal, this.sqlType);
            } else {
                String enumString = ((Enum)value).name();
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Binding '{0}' to parameter: {1}", enumString, index);
                }
                st.setObject(index, (Object)enumString, this.sqlType);
            }
        }
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            this.enumClass = reader.getReturnedClass().asSubclass(Enum.class);
            javax.persistence.EnumType enumType = this.getEnumType(reader);
            if (enumType == null) return;
            if (javax.persistence.EnumType.ORDINAL.equals((Object)enumType)) {
                this.sqlType = 4;
                return;
            } else {
                if (!javax.persistence.EnumType.STRING.equals((Object)enumType)) throw new AssertionFailure("Unknown EnumType: " + enumType);
                this.sqlType = 12;
            }
            return;
        }
        String enumClassName = (String)parameters.get(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", exception);
        }
        String type = (String)parameters.get(TYPE);
        if (type == null) return;
        this.sqlType = Integer.decode(type);
    }

    private void initEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.enumClass.getEnumConstants();
            if (this.enumValues == null) {
                throw new NullPointerException("Failed to init enumValues");
            }
        }
    }

    @Override
    public String objectToSQLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return '\'' + ((Enum)value).name() + '\'';
    }

    @Override
    public String toXMLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return ((Enum)value).name();
    }

    @Override
    public Object fromXMLString(String xmlValue) {
        try {
            int ordinal = Integer.parseInt(xmlValue);
            this.initEnumValues();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            return this.enumValues[ordinal];
        }
        catch (NumberFormatException e) {
            try {
                return Enum.valueOf(this.enumClass, xmlValue);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + xmlValue, iae);
            }
        }
    }

    private javax.persistence.EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        javax.persistence.EnumType enumType = null;
        if (reader.isPrimaryKey()) {
            MapKeyEnumerated enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        } else {
            Enumerated enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
            if (enumAnn != null) {
                enumType = enumAnn.value();
            }
        }
        return enumType;
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> anClass) {
        for (Annotation annotation : annotations) {
            if (!anClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }
}

