/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.binding.AbstractCollectionElement;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.Datatype;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Value;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

class HibernateTypeResolver {
    private final MetadataImplementor metadata;

    HibernateTypeResolver(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    void resolve() {
        for (EntityBinding entityBinding : this.metadata.getEntityBindings()) {
            if (entityBinding.getHierarchyDetails().getEntityDiscriminator() != null) {
                this.resolveDiscriminatorTypeInformation(entityBinding.getHierarchyDetails().getEntityDiscriminator());
            }
            for (AttributeBinding attributeBinding : entityBinding.attributeBindings()) {
                if (SingularAttributeBinding.class.isInstance(attributeBinding)) {
                    this.resolveSingularAttributeTypeInformation((SingularAttributeBinding)SingularAttributeBinding.class.cast(attributeBinding));
                    continue;
                }
                if (AbstractPluralAttributeBinding.class.isInstance(attributeBinding)) {
                    this.resolvePluralAttributeTypeInformation((AbstractPluralAttributeBinding)AbstractPluralAttributeBinding.class.cast(attributeBinding));
                    continue;
                }
                throw new AssertionFailure("Unknown type of AttributeBinding: " + attributeBinding.getClass().getName());
            }
        }
    }

    private void resolveDiscriminatorTypeInformation(EntityDiscriminator discriminator) {
        Type resolvedHibernateType = this.determineSingularTypeFromDescriptor(discriminator.getExplicitHibernateTypeDescriptor());
        if (resolvedHibernateType != null) {
            this.pushHibernateTypeInformationDownIfNeeded(discriminator.getExplicitHibernateTypeDescriptor(), discriminator.getBoundValue(), resolvedHibernateType);
        }
    }

    private Type determineSingularTypeFromDescriptor(HibernateTypeDescriptor hibernateTypeDescriptor) {
        if (hibernateTypeDescriptor.getResolvedTypeMapping() != null) {
            return hibernateTypeDescriptor.getResolvedTypeMapping();
        }
        String typeName = HibernateTypeResolver.determineTypeName(hibernateTypeDescriptor);
        Properties typeParameters = HibernateTypeResolver.getTypeParameters(hibernateTypeDescriptor);
        return this.getHeuristicType(typeName, typeParameters);
    }

    private static String determineTypeName(HibernateTypeDescriptor hibernateTypeDescriptor) {
        return hibernateTypeDescriptor.getExplicitTypeName() != null ? hibernateTypeDescriptor.getExplicitTypeName() : hibernateTypeDescriptor.getJavaTypeName();
    }

    private static Properties getTypeParameters(HibernateTypeDescriptor hibernateTypeDescriptor) {
        Properties typeParameters = new Properties();
        if (hibernateTypeDescriptor.getTypeParameters() != null) {
            typeParameters.putAll(hibernateTypeDescriptor.getTypeParameters());
        }
        return typeParameters;
    }

    private void resolveSingularAttributeTypeInformation(SingularAttributeBinding attributeBinding) {
        if (attributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping() != null) {
            return;
        }
        Type resolvedType = this.determineSingularTypeFromDescriptor(attributeBinding.getHibernateTypeDescriptor());
        if (resolvedType == null) {
            if (!attributeBinding.getAttribute().isSingular()) {
                throw new AssertionFailure("SingularAttributeBinding object has a plural attribute: " + attributeBinding.getAttribute().getName());
            }
            SingularAttribute singularAttribute = (SingularAttribute)attributeBinding.getAttribute();
            if (singularAttribute.getSingularAttributeType() != null) {
                resolvedType = this.getHeuristicType(singularAttribute.getSingularAttributeType().getClassName(), new Properties());
            }
        }
        if (resolvedType != null) {
            this.pushHibernateTypeInformationDownIfNeeded(attributeBinding, resolvedType);
        }
    }

    private void resolvePluralAttributeTypeInformation(AbstractPluralAttributeBinding attributeBinding) {
        if (attributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping() != null) {
            return;
        }
        String typeName = attributeBinding.getHibernateTypeDescriptor().getExplicitTypeName();
        Type resolvedType = typeName != null ? this.metadata.getTypeResolver().getTypeFactory().customCollection(typeName, HibernateTypeResolver.getTypeParameters(attributeBinding.getHibernateTypeDescriptor()), attributeBinding.getAttribute().getName(), attributeBinding.getReferencedPropertyName(), attributeBinding.getCollectionElement().getCollectionElementNature() == CollectionElementNature.COMPOSITE) : this.determineDefaultCollectionInformation(attributeBinding);
        if (resolvedType != null) {
            this.pushHibernateTypeInformationDownIfNeeded(attributeBinding.getHibernateTypeDescriptor(), null, resolvedType);
        }
        this.resolveCollectionElementTypeInformation(attributeBinding.getCollectionElement());
    }

    private Type determineDefaultCollectionInformation(AbstractPluralAttributeBinding attributeBinding) {
        TypeFactory typeFactory = this.metadata.getTypeResolver().getTypeFactory();
        switch (attributeBinding.getAttribute().getNature()) {
            case SET: {
                return typeFactory.set(attributeBinding.getAttribute().getName(), attributeBinding.getReferencedPropertyName(), attributeBinding.getCollectionElement().getCollectionElementNature() == CollectionElementNature.COMPOSITE);
            }
            case BAG: {
                return typeFactory.bag(attributeBinding.getAttribute().getName(), attributeBinding.getReferencedPropertyName(), attributeBinding.getCollectionElement().getCollectionElementNature() == CollectionElementNature.COMPOSITE);
            }
        }
        throw new UnsupportedOperationException("Collection type not supported yet:" + (Object)((Object)attributeBinding.getAttribute().getNature()));
    }

    private void resolveCollectionElementTypeInformation(AbstractCollectionElement collectionElement) {
        switch (collectionElement.getCollectionElementNature()) {
            case BASIC: {
                this.resolveBasicCollectionElement((BasicCollectionElement)BasicCollectionElement.class.cast(collectionElement));
                break;
            }
            case COMPOSITE: 
            case ONE_TO_MANY: 
            case MANY_TO_MANY: 
            case MANY_TO_ANY: {
                throw new UnsupportedOperationException("Collection element nature not supported yet: " + (Object)((Object)collectionElement.getCollectionElementNature()));
            }
            default: {
                throw new AssertionFailure("Unknown collection element nature : " + (Object)((Object)collectionElement.getCollectionElementNature()));
            }
        }
    }

    private void resolveBasicCollectionElement(BasicCollectionElement basicCollectionElement) {
        Type resolvedHibernateType = this.determineSingularTypeFromDescriptor(basicCollectionElement.getHibernateTypeDescriptor());
        if (resolvedHibernateType != null) {
            this.pushHibernateTypeInformationDownIfNeeded(basicCollectionElement.getHibernateTypeDescriptor(), basicCollectionElement.getElementValue(), resolvedHibernateType);
        }
    }

    private Type getHeuristicType(String typeName, Properties typeParameters) {
        if (typeName != null) {
            try {
                return this.metadata.getTypeResolver().heuristicType(typeName, typeParameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void pushHibernateTypeInformationDownIfNeeded(SingularAttributeBinding attributeBinding, Type resolvedHibernateType) {
        HibernateTypeDescriptor hibernateTypeDescriptor = attributeBinding.getHibernateTypeDescriptor();
        SingularAttribute singularAttribute = (SingularAttribute)SingularAttribute.class.cast(attributeBinding.getAttribute());
        Value value = attributeBinding.getValue();
        if (!singularAttribute.isTypeResolved() && hibernateTypeDescriptor.getJavaTypeName() != null) {
            singularAttribute.resolveType(this.metadata.makeJavaType(hibernateTypeDescriptor.getJavaTypeName()));
        }
        this.pushHibernateTypeInformationDownIfNeeded(hibernateTypeDescriptor, value, resolvedHibernateType);
    }

    private void pushHibernateTypeInformationDownIfNeeded(HibernateTypeDescriptor hibernateTypeDescriptor, Value value, Type resolvedHibernateType) {
        SimpleValue simpleValue;
        if (resolvedHibernateType == null) {
            return;
        }
        if (hibernateTypeDescriptor.getResolvedTypeMapping() == null) {
            hibernateTypeDescriptor.setResolvedTypeMapping(resolvedHibernateType);
        }
        if (hibernateTypeDescriptor.getJavaTypeName() == null) {
            hibernateTypeDescriptor.setJavaTypeName(resolvedHibernateType.getReturnedClass().getName());
        }
        if (SimpleValue.class.isInstance(value) && (simpleValue = (SimpleValue)value).getDatatype() == null) {
            simpleValue.setDatatype(new Datatype(resolvedHibernateType.sqlTypes(this.metadata)[0], resolvedHibernateType.getName(), resolvedHibernateType.getReturnedClass()));
        }
    }
}

