/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Table;

public class UniqueKey
extends AbstractConstraint
implements Constraint {
    protected UniqueKey(Table table, String name) {
        super(table, name);
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder sb = new StringBuilder(this.getTable().getLoggableValueQualifier());
        sb.append(".UK");
        for (Column column : this.getColumns()) {
            sb.append('_').append(column.getColumnName().getName());
        }
        return sb.toString();
    }

    @Override
    public boolean isCreationVetoed(Dialect dialect) {
        if (dialect.supportsNotNullUnique()) {
            return false;
        }
        for (Column column : this.getColumns()) {
            if (!column.isNullable()) continue;
            return true;
        }
        return false;
    }

    public String sqlConstraintStringInCreateTable(Dialect dialect) {
        StringBuilder buf = new StringBuilder("unique (");
        boolean hadNullableColumn = false;
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            if (!hadNullableColumn && column.isNullable()) {
                hadNullableColumn = true;
            }
            buf.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return !hadNullableColumn || dialect.supportsNotNullUnique() ? buf.append(')').toString() : null;
    }

    @Override
    public String sqlConstraintStringInAlterTable(Dialect dialect) {
        StringBuilder buf = new StringBuilder(dialect.getAddUniqueConstraintString(this.getName())).append('(');
        boolean nullable = false;
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            if (!nullable && column.isNullable()) {
                nullable = true;
            }
            buf.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return !nullable || dialect.supportsNotNullUnique() ? buf.append(')').toString() : null;
    }
}

