/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.verification;

import io.grpc.MethodDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.matcher.HeadersMatcher;
import org.grpcmock.definitions.matcher.RequestMatcher;
import org.grpcmock.definitions.matcher.StatusMatcher;
import org.grpcmock.interceptors.CapturedRequest;

public class RequestPattern<ReqT> {
    private final MethodDescriptor<ReqT, ?> method;
    private final StatusMatcher statusMatcher;
    private final HeadersMatcher headersMatcher;
    private final RequestMatcher<ReqT> requestsMatcher;

    RequestPattern(@Nonnull MethodDescriptor<ReqT, ?> method, @Nonnull StatusMatcher statusMatcher, @Nonnull HeadersMatcher headersMatcher, @Nonnull RequestMatcher<ReqT> requestsMatcher) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(statusMatcher);
        Objects.requireNonNull(headersMatcher);
        Objects.requireNonNull(requestsMatcher);
        this.method = method;
        this.statusMatcher = statusMatcher;
        this.headersMatcher = headersMatcher;
        this.requestsMatcher = requestsMatcher;
    }

    public String fullMethodName() {
        return this.method.getFullMethodName();
    }

    public boolean matches(CapturedRequest<ReqT> capturedRequest) {
        return capturedRequest.method().getFullMethodName().equals(this.method.getFullMethodName()) && this.statusMatcher.matches(capturedRequest.closeStatus()) && this.headersMatcher.matches(capturedRequest.headers()) && this.requestsMatcher.matches(this.normalizeRequests(capturedRequest.requests()));
    }

    public CapturedRequest<ReqT> normalizedCapturedRequest(CapturedRequest<ReqT> captured) {
        return new CapturedRequest<ReqT>(this.method, captured.headers(), this.normalizeRequests(captured.requests()));
    }

    private List<ReqT> normalizeRequests(List<ReqT> requests) {
        return requests.stream().map(this::normalizeRequest).collect(Collectors.toList());
    }

    private ReqT normalizeRequest(ReqT request) {
        if (request instanceof byte[]) {
            return (ReqT)this.method.getRequestMarshaller().parse((InputStream)new ByteArrayInputStream((byte[])request));
        }
        return request;
    }
}

