/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class WrapperPrintStream
extends FilterOutputStream {
    private String prefix;
    private PrintStream printStream;
    private ByteArrayOutputStream buffer;

    public WrapperPrintStream(String prefix, PrintStream printStream) {
        super(printStream);
        this.prefix = prefix;
        this.printStream = printStream;
        this.buffer = new ByteArrayOutputStream();
    }

    private void dumpBuffer() throws IOException {
        this.printStream.append(this.prefix);
        this.printStream.write(this.buffer.toByteArray());
        this.printStream.flush();
        this.buffer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(int c) throws IOException {
        PrintStream printStream = this.printStream;
        synchronized (printStream) {
            this.buffer.write(c);
            if (c == 10) {
                this.dumpBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        PrintStream printStream = this.printStream;
        synchronized (printStream) {
            for (int i = 0; i != len; ++i) {
                if (b[off + i] != 10) continue;
                this.writeByChars(b, off, len);
                return;
            }
            this.buffer.write(b, off, len);
        }
    }

    private void writeByChars(byte[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i != len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public void close() throws IOException {
        super.flush();
        this.dumpBuffer();
    }
}

