/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.vicluster.telecontrol.ssh.GlobHelper;
import org.gridkit.vicluster.telecontrol.ssh.SimpleSshSessionProvider;
import org.gridkit.vicluster.telecontrol.ssh.SshSessionFactory;

@Deprecated
public class ConfigurableSshSessionProvider
implements SshSessionFactory {
    private static final Pattern ENTRY_PATTERN = Pattern.compile("(\\w+@)?([a-zA-Z0-9.*?\\-]+)([!][a-zA-Z\\-]+)?");
    private static final String CFG_DEFAULT_PROFILE = "default-profile";
    private static final String CFG_HOSTNAME = "hostname";
    private static final String CFG_LOGIN = "login";
    private static final String CFG_PASSWORD = "password";
    private static final String CFG_PRIVATE_KEY = "private-key";
    private List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public static void configure(ConfigurableSshSessionProvider provider, Properties props) {
        for (Object prop : props.keySet()) {
            String key = (String)prop;
            Matcher matcher = ENTRY_PATTERN.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Wrong key format: " + key);
            }
            String profile = matcher.group(1);
            String host = matcher.group(2);
            String conf = matcher.group(3);
            String value = props.getProperty(key);
            if (value.startsWith("$") && System.getProperties().containsKey(value.substring(1))) {
                value = System.getProperty(value.substring(1));
            }
            if (profile != null) {
                profile = profile.substring(0, profile.length() - 1);
            }
            if (conf != null) {
                conf = conf.substring(1);
            }
            if (profile == null) {
                if (conf != null) {
                    throw new IllegalArgumentException("Wrong key format: " + key);
                }
                provider.hosts(host).defaultProfile(value);
                continue;
            }
            if (CFG_LOGIN.equals(conf)) {
                provider.hosts(host).profile(profile).useLogin(value);
                continue;
            }
            if (CFG_PASSWORD.equals(conf)) {
                provider.hosts(host).profile(profile).usePassword(value);
                continue;
            }
            if (CFG_PRIVATE_KEY.equals(conf)) {
                provider.hosts(host).profile(profile).usePrivateKey(value);
                continue;
            }
            if (CFG_HOSTNAME.equals(conf)) {
                provider.hosts(host).profile(profile).overrideHostname(value);
                continue;
            }
            throw new IllegalArgumentException("Wrong key format: " + key);
        }
    }

    public ConfigurableSshSessionProvider() {
    }

    public ConfigurableSshSessionProvider(Properties props) {
        this();
        ConfigurableSshSessionProvider.configure(this, props);
    }

    @Override
    public Session getSession(String host, String account) throws JSchException {
        if (account == null) {
            String user = this.findDefaultAccount(host);
            if (user == null) {
                throw new IllegalArgumentException("No default account found for host " + host);
            }
            return this.getSession(host, user);
        }
        String targetHost = host;
        Map<String, String> config = this.resolveConfig(host, account);
        SimpleSshSessionProvider simpleProvider = new SimpleSshSessionProvider();
        if (config.containsKey(CFG_LOGIN)) {
            simpleProvider.setUser(config.get(CFG_LOGIN));
        } else {
            simpleProvider.setUser(account);
        }
        if (config.containsKey(CFG_PASSWORD)) {
            simpleProvider.setPassword(config.get(CFG_PASSWORD));
        }
        if (config.containsKey(CFG_PRIVATE_KEY)) {
            simpleProvider.setKeyFile(this.resolveFile(config.get(CFG_PRIVATE_KEY)));
        }
        if (config.containsKey(CFG_HOSTNAME)) {
            targetHost = config.get(CFG_HOSTNAME);
        }
        return simpleProvider.getSession(targetHost, null);
    }

    private String resolveFile(String filename) {
        if (filename.startsWith("~/")) {
            String home = System.getProperty("user.home");
            filename = home + filename.substring(1);
        }
        return filename;
    }

    private Map<String, String> resolveConfig(String host, String account) {
        if (host.lastIndexOf(58) >= 0) {
            host = host.substring(0, host.lastIndexOf(58));
        }
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        for (ConfigEntry entry : this.entries) {
            if (!entry.matches(host, account)) continue;
            config.put(entry.getConfigProp(), entry.getConfigValue());
        }
        return config;
    }

    private String findDefaultAccount(String host) {
        String user = null;
        for (ConfigEntry entry : this.entries) {
            if (!entry.matches(host, null) || !CFG_DEFAULT_PROFILE.equals(entry.getConfigProp())) continue;
            user = entry.getConfigValue();
        }
        return user;
    }

    public SshConfig hosts(String pattern) {
        return new SshConfigBuilder(pattern);
    }

    private static class ConfigEntry {
        private String hostPattern;
        private Pattern compiledPattern;
        private String user;
        private String configProp;
        private String value;

        public ConfigEntry(String hostPattern, String user, String configProp, String value) {
            this.hostPattern = hostPattern;
            this.user = user;
            this.configProp = configProp;
            this.value = value;
            this.compiledPattern = GlobHelper.translate(hostPattern, ".");
        }

        public boolean matches(String host, String user) {
            if (this.user != null && !this.user.equals(user)) {
                return false;
            }
            if (this.user == null && user != null) {
                return false;
            }
            return this.compiledPattern.matcher(host).matches();
        }

        public String getConfigProp() {
            return this.configProp;
        }

        public String getConfigValue() {
            return this.value;
        }
    }

    private class SshConfigBuilder
    implements SshConfig {
        private String hostPattern;
        private String profile = null;

        public SshConfigBuilder(String hostPattern) {
            this.hostPattern = hostPattern;
        }

        @Override
        public SshConfig profile(String account) {
            this.profile = account;
            return this;
        }

        @Override
        public SshConfig defaultProfile() {
            if (this.profile == null) {
                throw new IllegalArgumentException("Profile name is not set");
            }
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, null, ConfigurableSshSessionProvider.CFG_DEFAULT_PROFILE, this.profile));
            return this;
        }

        @Override
        public SshConfig defaultProfile(String account) {
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, null, ConfigurableSshSessionProvider.CFG_DEFAULT_PROFILE, account));
            return this;
        }

        @Override
        public SshConfig useLogin(String login) {
            if (this.profile == null) {
                throw new IllegalArgumentException("Profile name is not set");
            }
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, this.profile, ConfigurableSshSessionProvider.CFG_LOGIN, login));
            return this;
        }

        @Override
        public SshConfig overrideHostname(String hostname) {
            if (this.profile == null) {
                throw new IllegalArgumentException("Profile name is not set");
            }
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, this.profile, ConfigurableSshSessionProvider.CFG_HOSTNAME, hostname));
            return this;
        }

        @Override
        public SshConfig usePassword(String password) {
            if (this.profile == null) {
                throw new IllegalArgumentException("Profile name is not set");
            }
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, this.profile, ConfigurableSshSessionProvider.CFG_PASSWORD, password));
            return this;
        }

        @Override
        public SshConfig usePrivateKey(String path) {
            if (this.profile == null) {
                throw new IllegalArgumentException("Profile name is not set");
            }
            ConfigurableSshSessionProvider.this.entries.add(new ConfigEntry(this.hostPattern, this.profile, ConfigurableSshSessionProvider.CFG_PRIVATE_KEY, path));
            return this;
        }
    }

    public static interface SshConfig {
        public SshConfig profile(String var1);

        public SshConfig defaultProfile();

        public SshConfig defaultProfile(String var1);

        public SshConfig useLogin(String var1);

        public SshConfig overrideHostname(String var1);

        public SshConfig usePassword(String var1);

        public SshConfig usePrivateKey(String var1);
    }
}

