/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.vicluster.Hooks;
import org.gridkit.vicluster.ViConfigurable;
import org.gridkit.vicluster.ViNode;
import org.gridkit.vicluster.ViNodeConfig;
import org.gridkit.vicluster.ViNodeProvider;
import org.gridkit.vicluster.WildProps;
import org.gridkit.vicluster.telecontrol.JvmProcessFactory;
import org.gridkit.vicluster.telecontrol.StreamCopyService;
import org.gridkit.vicluster.telecontrol.jvm.JvmNodeProvider;
import org.gridkit.vicluster.telecontrol.ssh.RemoteJmvReplicator;
import org.gridkit.vicluster.telecontrol.ssh.RemoteNodeProps;
import org.gridkit.vicluster.telecontrol.ssh.TunnellerJvmReplicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSshReplicator
implements ViNodeProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableSshReplicator.class);
    private final StreamCopyService streamCopyService;
    private Map<String, WildProps> sshConfCache = new HashMap<String, WildProps>();
    private Map<String, SessionInfo> sessions = new HashMap<String, SessionInfo>();
    private ViNodeConfig defaultConfig = new ViNodeConfig();

    public ConfigurableSshReplicator(StreamCopyService streamCopyService) {
        this.streamCopyService = streamCopyService;
        RemoteNodeProps.setRemoteJarCachePath((ViConfigurable)this.defaultConfig, ".gridagent");
    }

    public ViConfigurable getDefaultConfig() {
        return this.defaultConfig;
    }

    public boolean verifyNodeConfig(ViNodeConfig config) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViNode createNode(String name, ViNodeConfig config) {
        SessionInfo session;
        ViNodeConfig effectiveConfig = new ViNodeConfig();
        this.defaultConfig.apply((ViConfigurable)effectiveConfig);
        config.apply((ViConfigurable)effectiveConfig);
        Object object = this;
        synchronized (object) {
            SshSessionConfig sc = this.resolveSsh(name, effectiveConfig);
            RemoteJmvReplicator proto = this.getReplicatorProto(sc);
            String fp = proto.getFingerPrint();
            session = this.sessions.get(fp);
            if (session == null) {
                session = new SessionInfo();
                session.config = sc;
                this.sessions.put(fp, session);
            }
        }
        object = session;
        synchronized (object) {
            if (session.replicator == null) {
                session.replicator = this.getReplicatorProto(session.config);
                try {
                    LOGGER.info("Establishing connection " + session.config.getConnectionSummary());
                    session.replicator.init();
                }
                catch (Exception e) {
                    session.replicator = null;
                    throw new RuntimeException("SSH connection failed. Host [" + session.config.host + "] Error [" + e.getMessage() + "]", e);
                }
            }
            final SessionInfo context = session;
            final ViNode node = new JvmNodeProvider((JvmProcessFactory)session.replicator).createNode(name, effectiveConfig);
            node.setConfigElement("hook:release-ssh", (Object)new Hooks.PostShutdownHook(new Runnable(){

                @Override
                public void run() {
                    ConfigurableSshReplicator.this.releaseConnection(context, node);
                }
            }));
            session.processes.add(node);
            return node;
        }
    }

    public void shutdown() {
    }

    private RemoteJmvReplicator getReplicatorProto(SshSessionConfig sc) {
        TunnellerJvmReplicator rep = new TunnellerJvmReplicator(this.streamCopyService);
        rep.configure(sc.toConfig());
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(SessionInfo session, ViNode connection) {
        SessionInfo sessionInfo = session;
        synchronized (sessionInfo) {
            session.processes.remove(connection);
            if (!session.processes.isEmpty()) {
                return;
            }
            LOGGER.info("Session " + session + " is not used");
            session.replicator.dispose();
            session.replicator = null;
        }
    }

    private synchronized SshSessionConfig resolveSsh(String name, ViNodeConfig nodeConfig) {
        WildProps sshconf;
        SshSessionConfig s = new SshSessionConfig();
        s.host = nodeConfig.getProp(RemoteNodeProps.HOST);
        if (s.host == null) {
            throw new IllegalArgumentException("Remote host is not specified for node '" + name + "'");
        }
        if (s.host.startsWith("~")) {
            s.host = ConfigurableSshReplicator.transform(s.host, name);
        }
        if ((sshconf = this.getConf(nodeConfig.getProp(RemoteNodeProps.SSH_CREDENTIAL_FILE))) != null) {
            s.account = sshconf.get(s.host);
            s.account = this.overrideUser(s.account, nodeConfig.getProp(RemoteNodeProps.ACCOUNT));
            s.password = sshconf.get(s.account + "@" + s.host + "!password");
            s.keyFile = sshconf.get(s.account + "@" + s.host + "!private-key");
            s.authMethods = sshconf.get(s.account + "@" + s.host + "!auth-methods");
            String hostOverride = sshconf.get(s.account + "@" + s.host + "!hostname");
            if (hostOverride != null) {
                s.host = hostOverride;
            }
        }
        s.account = this.overrideUser(s.account, nodeConfig.getProp(RemoteNodeProps.ACCOUNT));
        s.password = this.override(s.password, nodeConfig.getProp(RemoteNodeProps.PASSWORD));
        s.keyFile = this.override(s.keyFile, nodeConfig.getProp(RemoteNodeProps.SSH_KEY_FILE));
        s.javaExec = this.override(s.javaExec, nodeConfig.getProp(RemoteNodeProps.JAVA_EXEC));
        s.jarCachePath = this.override(s.jarCachePath, nodeConfig.getProp(RemoteNodeProps.JAR_CACHE_PATH));
        if (s.host == null) {
            throw new IllegalArgumentException("Remote host is not specified for node '" + name + "'");
        }
        if (s.account == null) {
            LOGGER.debug("Use default account for [" + name + "]");
            s.account = System.getProperty("user.name");
            if (s.account == null || s.account.trim().length() == 0) {
                throw new IllegalArgumentException("No account found for node '" + name + "'");
            }
        }
        if (s.password == null && s.keyFile == null) {
            if (s.account.equals(System.getProperty("user.name"))) {
                LOGGER.debug("Use default SSH keys [" + name + "]");
                s.keyFile = "~/.ssh/id_dsa|~/.ssh/id_rsa";
            } else {
                throw new IllegalArgumentException("No creadetials found for node '" + name + "'");
            }
        }
        if (s.javaExec == null) {
            throw new IllegalArgumentException("Java command is not specified for '" + name + "'");
        }
        if (s.jarCachePath == null) {
            throw new IllegalArgumentException("Jar cache location is not specified for '" + name + "'");
        }
        return s;
    }

    private String override(String def, String override) {
        if (override != null) {
            return override;
        }
        return def;
    }

    private String overrideUser(String def, String override) {
        if (override != null) {
            return override;
        }
        if (def == null) {
            return System.getProperty("user.name");
        }
        return def;
    }

    private synchronized WildProps getConf(String path) {
        if (path == null) {
            return null;
        }
        if (this.sshConfCache.containsKey(path)) {
            return this.sshConfCache.get(path);
        }
        boolean optional = false;
        if (path.startsWith("?")) {
            optional = true;
            path = path.substring(1);
        }
        try {
            InputStream is = null;
            if (path.startsWith("~/")) {
                String userHome = System.getProperty("user.home");
                File cpath = new File(new File(userHome), path.substring(2));
                is = new FileInputStream(cpath);
            } else if (path.startsWith("resource:")) {
                String rpath = path.substring("resource:".length());
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                is = cl.getResourceAsStream(rpath);
                if (is == null) {
                    throw new FileNotFoundException("Resource not found '" + path + "'");
                }
            } else if (new File(path).exists()) {
                is = new FileInputStream(new File(path));
            } else {
                try {
                    is = new URL(path).openStream();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (is == null) {
                    throw new FileNotFoundException("Cannot resolve path '" + path + "'");
                }
            }
            WildProps wp = new WildProps();
            wp.load(is);
            this.sshConfCache.put(path, wp);
            return wp;
        }
        catch (IOException e) {
            if (optional) {
                LOGGER.info("SSH config [" + path + "] is not found");
                this.sshConfCache.put("?" + path, null);
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    static String transform(String pattern, String name) {
        int n = pattern.indexOf(33);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid host extractor [" + pattern + "]");
        }
        String format = pattern.substring(1, n);
        Matcher m = Pattern.compile(pattern.substring(n + 1)).matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException("Host extractor [" + pattern + "] is not applicable to name '" + name + "'");
        }
        Object[] groups = new Object[m.groupCount()];
        for (int i = 0; i != groups.length; ++i) {
            groups[i] = m.group(i + 1);
            try {
                groups[i] = new Long((String)groups[i]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            return String.format(format, groups);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Host extractor [" + pattern + "] is not applicable to name '" + name + "'");
        }
    }

    private static class SessionInfo {
        SshSessionConfig config;
        RemoteJmvReplicator replicator;
        List<ViNode> processes = new ArrayList<ViNode>();

        private SessionInfo() {
        }
    }

    private static class SshSessionConfig {
        String host;
        String account;
        String password;
        String keyFile;
        String authMethods;
        String javaExec;
        String jarCachePath;

        private SshSessionConfig() {
        }

        public Map<String, String> toConfig() {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put(RemoteNodeProps.HOST, this.host);
            config.put(RemoteNodeProps.ACCOUNT, this.account);
            config.put(RemoteNodeProps.PASSWORD, this.password);
            config.put(RemoteNodeProps.SSH_KEY_FILE, this.keyFile);
            config.put(RemoteNodeProps.SSH_AUTH_METHODS, this.authMethods);
            config.put(RemoteNodeProps.JAVA_EXEC, this.javaExec);
            config.put(RemoteNodeProps.JAR_CACHE_PATH, this.jarCachePath);
            return config;
        }

        public String getConnectionSummary() {
            return this.account + "@" + this.host + " - " + (this.keyFile == null ? "" : " pk-auth(" + this.keyFile + ")") + (this.password == null ? "" : " password-auth");
        }

        public String toString() {
            return this.host + "|" + this.account + "|" + this.password + "|" + this.keyFile + "|" + this.javaExec + "|" + this.jarCachePath;
        }
    }
}

