/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.internal.com.jcraft.jsch;

import java.util.Vector;
import org.gridkit.internal.com.jcraft.jsch.Identity;
import org.gridkit.internal.com.jcraft.jsch.IdentityFile;
import org.gridkit.internal.com.jcraft.jsch.IdentityRepository;
import org.gridkit.internal.com.jcraft.jsch.JSch;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Util;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jsch) {
        this.jsch = jsch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector getIdentities() {
        Vector v = new Vector();
        for (int i = 0; i < this.identities.size(); ++i) {
            v.addElement(this.identities.elementAt(i));
        }
        return v;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] identity) {
        try {
            IdentityFile _identity = IdentityFile.newInstance("from remote:", identity, null, this.jsch);
            this.identities.addElement(_identity);
            return true;
        }
        catch (JSchException e) {
            return false;
        }
    }

    @Override
    public synchronized boolean remove(byte[] blob) {
        if (blob == null) {
            return false;
        }
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity _identity = (Identity)this.identities.elementAt(i);
            byte[] _blob = _identity.getPublicKeyBlob();
            if (_blob == null || !Util.array_equals(blob, _blob)) continue;
            this.identities.removeElement(_identity);
            _identity.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity identity = (Identity)this.identities.elementAt(i);
            identity.clear();
        }
        this.identities.removeAllElements();
    }
}

