/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.compute.gridify.aop.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridGainState;
import org.gridgain.grid.compute.GridComputeTask;
import org.gridgain.grid.compute.gridify.Gridify;
import org.gridgain.grid.compute.gridify.GridifyArgument;
import org.gridgain.grid.compute.gridify.GridifyInterceptor;
import org.gridgain.grid.compute.gridify.GridifyRuntimeException;
import org.gridgain.grid.compute.gridify.aop.GridifyArgumentAdapter;
import org.gridgain.grid.compute.gridify.aop.GridifyDefaultTask;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.G;

public class GridifySpringAspect
implements MethodInterceptor {
    public Object invoke(MethodInvocation invoc) throws Throwable {
        String gridName;
        Method mtd = invoc.getMethod();
        Gridify ann = mtd.getAnnotation(Gridify.class);
        assert (ann != null) : "Intercepted method does not have gridify annotation.";
        String string = gridName = F.isEmpty((String)ann.gridName()) ? null : ann.gridName();
        if (G.state((String)gridName) != GridGainState.STARTED) {
            throw new GridException("Grid is not locally started: " + gridName);
        }
        GridifyArgumentAdapter arg = new GridifyArgumentAdapter(mtd.getDeclaringClass(), mtd.getName(), (Class[])mtd.getParameterTypes(), invoc.getArguments(), invoc.getThis());
        if (!ann.interceptor().equals(GridifyInterceptor.class) && !((GridifyInterceptor)ann.interceptor().newInstance()).isGridify((Annotation)ann, (GridifyArgument)arg)) {
            return invoc.proceed();
        }
        if (!ann.taskClass().equals(GridifyDefaultTask.class) && !ann.taskName().isEmpty()) {
            throw new GridException("Gridify annotation must specify either Gridify.taskName() or Gridify.taskClass(), but not both: " + ann);
        }
        try {
            Grid grid = G.grid((String)gridName);
            if (!ann.taskClass().equals(GridifyDefaultTask.class)) {
                return grid.compute().withTimeout(ann.timeout()).execute(ann.taskClass(), (Object)arg).get();
            }
            if (ann.taskName().isEmpty()) {
                return grid.compute().withTimeout(ann.timeout()).execute((GridComputeTask)new GridifyDefaultTask(invoc.getMethod().getDeclaringClass()), (Object)arg).get();
            }
            return grid.compute().withTimeout(ann.timeout()).execute(ann.taskName(), (Object)arg).get();
        }
        catch (Throwable e) {
            for (Class<?> ex : invoc.getMethod().getExceptionTypes()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!ex.isAssignableFrom(cause.getClass())) continue;
                    throw cause;
                }
                if (!ex.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new GridifyRuntimeException("Undeclared exception thrown: " + e.getMessage(), e);
        }
    }
}

