/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.compute.gridify.aop.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridGainState;
import org.gridgain.grid.GridProjection;
import org.gridgain.grid.compute.gridify.GridifyArgument;
import org.gridgain.grid.compute.gridify.GridifyInterceptor;
import org.gridgain.grid.compute.gridify.GridifyNodeFilter;
import org.gridgain.grid.compute.gridify.GridifyRuntimeException;
import org.gridgain.grid.compute.gridify.GridifySetToSet;
import org.gridgain.grid.compute.gridify.aop.GridifySetToSetAbstractAspect;
import org.gridgain.grid.util.gridify.GridifyArgumentBuilder;
import org.gridgain.grid.util.gridify.GridifyRangeArgument;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.G;

public class GridifySetToSetSpringAspect
extends GridifySetToSetAbstractAspect
implements MethodInterceptor {
    public Object invoke(MethodInvocation invoc) throws Throwable {
        String gridName;
        Method mtd = invoc.getMethod();
        GridifySetToSet ann = mtd.getAnnotation(GridifySetToSet.class);
        assert (ann != null) : "Intercepted method does not have gridify annotation.";
        String string = gridName = F.isEmpty((String)ann.gridName()) ? null : ann.gridName();
        if (G.state((String)gridName) != GridGainState.STARTED) {
            throw new GridException("Grid is not locally started: " + gridName);
        }
        GridifyNodeFilter nodeFilter = null;
        if (!ann.nodeFilter().equals(GridifyNodeFilter.class)) {
            nodeFilter = (GridifyNodeFilter)ann.nodeFilter().newInstance();
        }
        GridifyArgumentBuilder argBuilder = new GridifyArgumentBuilder();
        GridifyRangeArgument arg = argBuilder.createTaskArgument(mtd.getDeclaringClass(), mtd.getName(), mtd.getReturnType(), (Class[])mtd.getParameterTypes(), mtd.getParameterAnnotations(), invoc.getArguments(), invoc.getThis());
        if (!ann.interceptor().equals(GridifyInterceptor.class) && !((GridifyInterceptor)ann.interceptor().newInstance()).isGridify((Annotation)ann, (GridifyArgument)arg)) {
            return invoc.proceed();
        }
        if (ann.threshold() < 0) {
            return invoc.proceed();
        }
        if (arg.getInputSize() != -1 && arg.getInputSize() <= ann.threshold()) {
            return invoc.proceed();
        }
        this.checkIsSplitToJobsAllowed(arg, ann);
        try {
            Grid grid = G.grid((String)gridName);
            return this.execute((GridProjection)grid, invoc.getMethod().getDeclaringClass(), arg, nodeFilter, ann.threshold(), ann.splitSize(), ann.timeout());
        }
        catch (Throwable e) {
            for (Class<?> ex : invoc.getMethod().getExceptionTypes()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!ex.isAssignableFrom(cause.getClass())) continue;
                    throw cause;
                }
                if (!ex.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new GridifyRuntimeException("Undeclared exception thrown: " + e.getMessage(), e);
        }
    }
}

