/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.event;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public class SyslogServerEvent
implements SyslogServerEventIF {
    private static final long serialVersionUID = 6136043067089899962L;
    public static final String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    public static final String DATE_FORMAT_S = "MMM d HH:mm:ss yyyy";
    protected String charSet = "UTF-8";
    protected String rawString = null;
    protected byte[] rawBytes = null;
    protected int rawLength = -1;
    protected Date date = null;
    protected int level = -1;
    protected int facility = -1;
    protected String host = null;
    protected boolean isHostStrippedFromMessage = false;
    protected String message = null;
    protected InetAddress inetAddress = null;

    protected SyslogServerEvent() {
    }

    public SyslogServerEvent(String message, InetAddress inetAddress) {
        this.initialize(message, inetAddress);
        this.parse();
    }

    public SyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        this.initialize(message, length, inetAddress);
        this.parse();
    }

    protected void initialize(String message, InetAddress inetAddress) {
        this.rawString = message;
        this.rawLength = message.length();
        this.inetAddress = inetAddress;
        this.message = message;
    }

    protected void initialize(byte[] message, int length, InetAddress inetAddress) {
        this.rawBytes = message;
        this.rawLength = length;
        this.inetAddress = inetAddress;
    }

    protected void parseHost() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.host = this.message.substring(0, i).trim();
        }
    }

    protected void parseDate() {
        int datelength = 16;
        String dateFormatS = DATE_FORMAT;
        if (this.message.length() > datelength) {
            if (this.message.charAt(5) == ' ') {
                datelength = 15;
                dateFormatS = DATE_FORMAT_S;
            }
            String year = Integer.toString(Calendar.getInstance().get(1));
            String originalDate = this.message.substring(0, datelength - 1) + " " + year;
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatS);
            try {
                this.date = dateFormat.parse(originalDate);
                this.message = this.message.substring(datelength);
            }
            catch (ParseException pe) {
                this.date = new Date();
            }
        }
        this.parseHost();
    }

    protected void parsePriority() {
        int i;
        if (this.message.charAt(0) == '<' && (i = this.message.indexOf(">")) <= 4 && i > -1) {
            String priorityStr = this.message.substring(1, i);
            int priority = 0;
            try {
                priority = Integer.parseInt(priorityStr);
                this.facility = priority >> 3;
                this.level = priority - (this.facility << 3);
                this.message = this.message.substring(i + 1);
                this.parseDate();
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.parseHost();
        }
    }

    protected void parse() {
        if (this.message == null) {
            this.message = SyslogUtility.newString(this, this.rawBytes, this.rawLength);
        }
        this.parsePriority();
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int facility) {
        this.facility = facility;
    }

    public byte[] getRaw() {
        if (this.rawString != null) {
            byte[] rawStringBytes = SyslogUtility.getBytes(this, this.rawString);
            return rawStringBytes;
        }
        if (this.rawBytes.length == this.rawLength) {
            return this.rawBytes;
        }
        byte[] newRawBytes = new byte[this.rawLength];
        System.arraycopy(this.rawBytes, 0, newRawBytes, 0, this.rawLength);
        return newRawBytes;
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isHostStrippedFromMessage() {
        return this.isHostStrippedFromMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }
}

