/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.unix.socket;

import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogConfig;
import org.graylog2.syslog4j.impl.unix.socket.UnixSocketSyslog;

public class UnixSocketSyslogConfig
extends AbstractSyslogConfig {
    private static final long serialVersionUID = -3145794243736015707L;
    protected int type = 2;
    protected short family = 1;
    protected int protocol = 0;
    protected String library = "c";
    protected String path = "/dev/log";

    public UnixSocketSyslogConfig() {
        this.setSendLocalName(false);
        this.setIdent("java");
    }

    public Class getSyslogClass() {
        return UnixSocketSyslog.class;
    }

    public UnixSocketSyslogConfig(int facility) {
        this.facility = facility;
    }

    public UnixSocketSyslogConfig(int facility, String path) {
        this.facility = facility;
        this.path = path;
    }

    public UnixSocketSyslogConfig(String path) {
        this.path = path;
    }

    public String getHost() {
        return null;
    }

    public int getPort() {
        return -1;
    }

    public void setHost(String host) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("Host not appropriate for class \"" + this.getClass().getName() + "\"");
    }

    public void setPort(int port) throws SyslogRuntimeException {
        throw new SyslogRuntimeException("Port not appropriate for class \"" + this.getClass().getName() + "\"");
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String type) {
        if (type == null) {
            throw new SyslogRuntimeException("Type cannot be null for class \"" + this.getClass().getName() + "\"");
        }
        if ("SOCK_STREAM".equalsIgnoreCase(type.trim())) {
            this.type = 1;
        } else if ("SOCK_DGRAM".equalsIgnoreCase(type.trim())) {
            this.type = 2;
        } else {
            throw new SyslogRuntimeException("Type must be \"SOCK_STREAM\" or \"SOCK_DGRAM\" for class \"" + this.getClass().getName() + "\"");
        }
    }

    public short getFamily() {
        return this.family;
    }

    public void setFamily(short family) {
        this.family = family;
    }

    public void setFamily(String family) {
        if (family == null) {
            throw new SyslogRuntimeException("Family cannot be null for class \"" + this.getClass().getName() + "\"");
        }
        if (!"AF_UNIX".equalsIgnoreCase(family.trim())) {
            throw new SyslogRuntimeException("Family must be \"AF_UNIX\" for class \"" + this.getClass().getName() + "\"");
        }
        this.family = 1;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getMaxQueueSize() {
        return -1;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        throw new SyslogRuntimeException("UnixSyslog protocol does not uses a queueing mechanism");
    }
}

