/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslog;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfigIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public class TCPNetSyslogWriter
extends AbstractSyslogWriter {
    private static final long serialVersionUID = -6388813866108482855L;
    protected TCPNetSyslog tcpNetSyslog = null;
    protected Socket socket = null;
    protected TCPNetSyslogConfigIF tcpNetSyslogConfig = null;
    protected long lastSocketCreationTimeMs = 0L;

    public void initialize(AbstractSyslog abstractSyslog) {
        super.initialize(abstractSyslog);
        this.tcpNetSyslog = (TCPNetSyslog)abstractSyslog;
        this.tcpNetSyslogConfig = (TCPNetSyslogConfigIF)this.tcpNetSyslog.getConfig();
    }

    protected SocketFactory obtainSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected Socket createSocket(InetAddress hostAddress, int port, boolean keepalive) throws IOException {
        SocketFactory socketFactory = this.obtainSocketFactory();
        Socket newSocket = socketFactory.createSocket(hostAddress, port);
        if (this.tcpNetSyslogConfig.isSoLinger()) {
            newSocket.setSoLinger(true, this.tcpNetSyslogConfig.getSoLingerSeconds());
        }
        if (this.tcpNetSyslogConfig.isKeepAlive()) {
            newSocket.setKeepAlive(keepalive);
        }
        if (this.tcpNetSyslogConfig.isReuseAddress()) {
            newSocket.setReuseAddress(true);
        }
        return newSocket;
    }

    protected Socket getSocket() throws SyslogRuntimeException {
        if (this.socket != null && this.socket.isConnected()) {
            int freshConnectionInterval = this.tcpNetSyslogConfig.getFreshConnectionInterval();
            if (freshConnectionInterval > 0) {
                long currentTimeMs = System.currentTimeMillis();
                if (currentTimeMs - this.lastSocketCreationTimeMs >= (long)freshConnectionInterval) {
                    this.closeSocket(this.socket);
                }
            } else {
                return this.socket;
            }
        }
        if (this.socket == null) {
            this.lastSocketCreationTimeMs = 0L;
            try {
                InetAddress hostAddress = this.tcpNetSyslog.getHostAddress();
                this.socket = this.createSocket(hostAddress, this.syslog.getConfig().getPort(), this.tcpNetSyslogConfig.isPersistentConnection());
                this.lastSocketCreationTimeMs = System.currentTimeMillis();
            }
            catch (IOException ioe) {
                throw new SyslogRuntimeException(ioe);
            }
        }
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket(Socket socketToClose) {
        if (socketToClose == null) {
            return;
        }
        try {
            socketToClose.close();
        }
        catch (IOException ioe) {
            if (!"Socket is closed".equalsIgnoreCase(ioe.getMessage())) {
                throw new SyslogRuntimeException(ioe);
            }
        }
        finally {
            if (socketToClose == this.socket) {
                this.socket = null;
            }
        }
    }

    public void write(byte[] message) throws SyslogRuntimeException {
        Socket currentSocket = null;
        int attempts = 0;
        while (attempts != -1 && attempts < this.tcpNetSyslogConfig.getWriteRetries() + 1) {
            try {
                currentSocket = this.getSocket();
                if (currentSocket == null) {
                    throw new SyslogRuntimeException("No socket available");
                }
                OutputStream os = currentSocket.getOutputStream();
                if (this.tcpNetSyslogConfig.isSetBufferSize()) {
                    currentSocket.setSendBufferSize(message.length);
                }
                os.write(message);
                byte[] delimiterSequence = this.tcpNetSyslogConfig.getDelimiterSequence();
                if (delimiterSequence != null && delimiterSequence.length > 0) {
                    os.write(delimiterSequence);
                }
                this.syslog.setBackLogStatus(false);
                attempts = -1;
                if (this.tcpNetSyslogConfig.isPersistentConnection()) continue;
                this.closeSocket(currentSocket);
            }
            catch (IOException ioe) {
                this.closeSocket(currentSocket);
                if (++attempts < this.tcpNetSyslogConfig.getWriteRetries() + 1) continue;
                throw new SyslogRuntimeException(ioe);
            }
        }
    }

    public synchronized void flush() throws SyslogRuntimeException {
        if (this.socket == null) {
            return;
        }
        if (this.syslogConfig.isThreaded()) {
            this.shutdown();
            this.syslog.createWriterThread(this);
        } else {
            this.closeSocket(this.socket);
        }
    }

    public synchronized void shutdown() throws SyslogRuntimeException {
        this.shutdown = true;
        if (this.syslogConfig.isThreaded()) {
            long timeStart = System.currentTimeMillis();
            boolean done = false;
            while (!done) {
                if (this.socket == null || this.socket.isClosed()) {
                    done = true;
                    continue;
                }
                long now = System.currentTimeMillis();
                if (now > timeStart + this.tcpNetSyslogConfig.getMaxShutdownWait()) {
                    this.closeSocket(this.socket);
                    this.thread.interrupt();
                    done = true;
                }
                if (done) continue;
                SyslogUtility.sleep(100L);
            }
        } else {
            if (this.socket == null || this.socket.isClosed()) {
                return;
            }
            this.closeSocket(this.socket);
        }
    }

    protected void runCompleted() {
        this.closeSocket(this.socket);
    }
}

