/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.structured;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graylog2.syslog4j.impl.message.AbstractSyslogMessage;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessageIF;

public class StructuredSyslogMessage
extends AbstractSyslogMessage
implements StructuredSyslogMessageIF {
    private static final long serialVersionUID = 3669887659567965965L;
    private String messageId;
    private Map structuredData;
    private String message;

    private StructuredSyslogMessage() {
        this.messageId = null;
        this.message = null;
        this.structuredData = null;
    }

    public StructuredSyslogMessage(String messageId, Map structuredData, String message) {
        this.messageId = messageId;
        this.structuredData = structuredData;
        this.message = message;
        this.ensureCorrectMapType();
    }

    private void ensureCorrectMapType() {
        if (this.getStructuredData() != null) {
            Set sdEntrySet = this.getStructuredData().entrySet();
            for (Map.Entry sdEntry : sdEntrySet) {
                if (!(sdEntry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
                if (!(sdEntry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
                Set entrySet = ((Map)sdEntry.getValue()).entrySet();
                for (Map.Entry entry : entrySet) {
                    if (!(entry.getKey() instanceof String)) {
                        throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                    }
                    if (entry.getValue() instanceof String) continue;
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
            }
        }
    }

    public static StructuredSyslogMessage fromString(String syslogMessageStr) {
        StructuredSyslogMessage syslogMessage = new StructuredSyslogMessage();
        syslogMessage.deserialize(syslogMessageStr);
        return syslogMessage;
    }

    private void deserialize(String stringMessage) {
        if (stringMessage.indexOf(91) <= 0) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        String syslogHeader = stringMessage.substring(0, stringMessage.indexOf(91));
        String structuredDataString = stringMessage.substring(stringMessage.indexOf(91), stringMessage.lastIndexOf(93) + 1);
        this.message = stringMessage.lastIndexOf(93) + 2 <= stringMessage.length() ? stringMessage.substring(stringMessage.lastIndexOf(93) + 2) : "";
        String[] tokens = syslogHeader.split(" ");
        if (tokens.length != 1) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        this.messageId = "-".equals(tokens[0]) ? null : tokens[0];
        this.structuredData = new HashMap();
        if (!"[0@0]".equals(structuredDataString)) {
            while (!"".equals(structuredDataString)) {
                if (!structuredDataString.startsWith("[") || structuredDataString.indexOf(93) == -1) {
                    throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + stringMessage);
                }
                String structuredDataIteration = structuredDataString.substring(1, structuredDataString.indexOf(93));
                HashMap<String, String> iterMap = new HashMap<String, String>();
                String[] params = structuredDataIteration.split(" ");
                for (int i = 1; i < params.length; ++i) {
                    String[] paramIter = params[i].split("=");
                    if (paramIter.length != 2) {
                        throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + stringMessage);
                    }
                    if (!paramIter[1].startsWith("\"") || !paramIter[1].endsWith("\"")) {
                        throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + stringMessage);
                    }
                    iterMap.put(paramIter[0], paramIter[1].substring(1, paramIter[1].length() - 1));
                }
                this.structuredData.put(params[0], iterMap);
                if (structuredDataString.indexOf(93) != structuredDataString.lastIndexOf(93)) {
                    structuredDataString = structuredDataString.substring(structuredDataString.indexOf(93) + 1);
                    continue;
                }
                structuredDataString = "";
            }
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Map getStructuredData() {
        return this.structuredData;
    }

    public String getMessage() {
        return this.message;
    }

    public String createMessage() {
        return this.serialize();
    }

    private String serialize() {
        if (!StructuredSyslogMessage.checkIsPrintable(this.getMessageId())) {
            throw new IllegalArgumentException("Invalid message id: " + this.getMessageId());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StructuredSyslogMessage.nilProtect(this.getMessageId()));
        sb.append(' ');
        if (this.getStructuredData() == null || this.getStructuredData().size() == 0) {
            sb.append("[0@0]");
        } else {
            Set sdEntrySet = this.getStructuredData().entrySet();
            for (Map.Entry sdElement : sdEntrySet) {
                String sdId = (String)sdElement.getKey();
                if (sdId == null || sdId.length() == 0 || !StructuredSyslogMessage.checkIsPrintable(sdId)) {
                    throw new IllegalArgumentException("Illegal structured data id: " + sdId);
                }
                sb.append('[').append(sdId);
                Map sdParams = (Map)sdElement.getValue();
                if (sdParams != null) {
                    Set entrySet = sdParams.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String paramName = (String)entry.getKey();
                        String paramValue = (String)entry.getValue();
                        if (paramName == null || paramName.length() == 0 || !StructuredSyslogMessage.checkIsPrintable(paramName)) {
                            throw new IllegalArgumentException("Illegal structured data parameter name: " + paramName);
                        }
                        if (paramValue == null) {
                            throw new IllegalArgumentException("Null structured data parameter value for parameter name: " + paramName);
                        }
                        sb.append(' ');
                        sb.append(paramName);
                        sb.append('=').append('\"');
                        StructuredSyslogMessage.sdEscape(sb, paramValue);
                        sb.append('\"');
                    }
                }
                sb.append(']');
            }
        }
        if (this.getMessage() != null && this.getMessage().length() != 0) {
            sb.append(' ');
            sb.append(StructuredSyslogMessage.nilProtect(this.getMessage()));
        }
        return sb.toString();
    }

    public static void sdEscape(StringBuffer sb, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\' || c == ']') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    public static boolean checkIsPrintable(String value) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String nilProtect(String value) {
        if (value == null || value.trim().length() == 0) {
            return "-";
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + (this.structuredData == null ? 0 : ((Object)this.structuredData).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredSyslogMessage other = (StructuredSyslogMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        return !(this.structuredData == null ? other.structuredData != null : !((Object)this.structuredData).equals(other.structuredData));
    }

    public String toString() {
        return this.serialize();
    }
}

