/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.graylog2.syslog4j.SyslogBackLogHandlerIF;
import org.graylog2.syslog4j.SyslogMessageModifierIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogConfigIF;
import org.graylog2.syslog4j.impl.backlog.printstream.SystemErrSyslogBackLogHandler;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogConfig
implements AbstractSyslogConfigIF {
    private static final long serialVersionUID = -3728308557871358111L;
    protected static final List defaultBackLogHandlers = new ArrayList();
    protected int facility = 8;
    protected String charSet = "UTF-8";
    protected String ident = "";
    protected String localName = null;
    protected boolean sendLocalTimestamp = true;
    protected boolean sendLocalName = true;
    protected boolean includeIdentInMessageModifier = false;
    protected boolean throwExceptionOnWrite = false;
    protected boolean throwExceptionOnInitialize = true;
    protected int maxMessageLength = 1024;
    protected byte[] splitMessageBeginText = "...".getBytes();
    protected byte[] splitMessageEndText = "...".getBytes();
    protected List messageModifiers = null;
    protected List backLogHandlers = null;
    protected boolean threaded = true;
    protected boolean useDaemonThread = true;
    protected int threadPriority = -1;
    protected long threadLoopInterval = 500L;
    protected int writeRetries = 2;
    protected long maxShutdownWait = 30000L;
    protected boolean truncateMessage = false;
    protected boolean useStructuredData = false;

    public abstract Class getSyslogClass();

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public boolean isThrowExceptionOnWrite() {
        return this.throwExceptionOnWrite;
    }

    public void setThrowExceptionOnWrite(boolean throwExceptionOnWrite) {
        this.throwExceptionOnWrite = throwExceptionOnWrite;
    }

    public boolean isThrowExceptionOnInitialize() {
        return this.throwExceptionOnInitialize;
    }

    public void setThrowExceptionOnInitialize(boolean throwExceptionOnInitialize) {
        this.throwExceptionOnInitialize = throwExceptionOnInitialize;
    }

    public byte[] getSplitMessageBeginText() {
        return this.splitMessageBeginText;
    }

    public void setSplitMessageBeginText(byte[] splitMessageBeginText) {
        this.splitMessageBeginText = splitMessageBeginText;
    }

    public void setSplitMessageBeginText(String splitMessageBeginText) throws SyslogRuntimeException {
        this.splitMessageBeginText = SyslogUtility.getBytes(this, splitMessageBeginText);
    }

    public byte[] getSplitMessageEndText() {
        return this.splitMessageEndText;
    }

    public void setSplitMessageEndText(byte[] splitMessageEndText) {
        this.splitMessageEndText = splitMessageEndText;
    }

    public void setSplitMessageEndText(String splitMessageEndText) throws SyslogRuntimeException {
        this.splitMessageEndText = SyslogUtility.getBytes(this, splitMessageEndText);
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public boolean isSendLocalTimestamp() {
        return this.sendLocalTimestamp;
    }

    public void setSendLocalTimestamp(boolean sendLocalTimestamp) {
        this.sendLocalTimestamp = sendLocalTimestamp;
    }

    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    public void setSendLocalName(boolean sendLocalName) {
        this.sendLocalName = sendLocalName;
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int facility) {
        this.facility = facility;
    }

    public void setFacility(String facilityName) {
        this.facility = SyslogUtility.getFacility(facilityName);
    }

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    protected synchronized List _getMessageModifiers() {
        if (this.messageModifiers == null) {
            this.messageModifiers = new ArrayList();
        }
        return this.messageModifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageModifier(SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.add(messageModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMessageModifier(int index, SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            try {
                _messageModifiers.add(index, messageModifier);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageModifier(SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.remove(messageModifier);
        }
    }

    public List getMessageModifiers() {
        return this.messageModifiers;
    }

    public void setMessageModifiers(List messageModifiers) {
        this.messageModifiers = messageModifiers;
    }

    public void removeAllMessageModifiers() {
        if (this.messageModifiers == null || this.messageModifiers.isEmpty()) {
            return;
        }
        this.messageModifiers.clear();
    }

    protected synchronized List _getBackLogHandlers() {
        if (this.backLogHandlers == null) {
            this.backLogHandlers = new ArrayList();
        }
        return this.backLogHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            backLogHandler.initialize();
            _backLogHandlers.add(backLogHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBackLogHandler(int index, SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            try {
                backLogHandler.initialize();
                _backLogHandlers.add(index, backLogHandler);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            _backLogHandlers.remove(backLogHandler);
        }
    }

    public List getBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.size() < 1) {
            return defaultBackLogHandlers;
        }
        return this.backLogHandlers;
    }

    public void setBackLogHandlers(List backLogHandlers) {
        this.backLogHandlers = backLogHandlers;
    }

    public void removeAllBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.isEmpty()) {
            return;
        }
        this.backLogHandlers.clear();
    }

    public boolean isIncludeIdentInMessageModifier() {
        return this.includeIdentInMessageModifier;
    }

    public void setIncludeIdentInMessageModifier(boolean includeIdentInMessageModifier) {
        this.includeIdentInMessageModifier = includeIdentInMessageModifier;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    public void setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public long getThreadLoopInterval() {
        return this.threadLoopInterval;
    }

    public void setThreadLoopInterval(long threadLoopInterval) {
        this.threadLoopInterval = threadLoopInterval;
    }

    public long getMaxShutdownWait() {
        return this.maxShutdownWait;
    }

    public void setMaxShutdownWait(long maxShutdownWait) {
        this.maxShutdownWait = maxShutdownWait;
    }

    public int getWriteRetries() {
        return this.writeRetries;
    }

    public void setWriteRetries(int writeRetries) {
        this.writeRetries = writeRetries;
    }

    public boolean isTruncateMessage() {
        return this.truncateMessage;
    }

    public void setTruncateMessage(boolean truncateMessage) {
        this.truncateMessage = truncateMessage;
    }

    public boolean isUseStructuredData() {
        return this.useStructuredData;
    }

    public void setUseStructuredData(boolean useStructuredData) {
        this.useStructuredData = useStructuredData;
    }

    public Class getSyslogWriterClass() {
        return null;
    }

    static {
        defaultBackLogHandlers.add(new SystemErrSyslogBackLogHandler());
    }
}

